/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.nodevalidation;

import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.nodevalidation.DiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.jetbrains.annotations.Nullable;

public class OsDiscoveryNodeValidationProcessor
extends GridProcessorAdapter
implements DiscoveryNodeValidationProcessor {
    public OsDiscoveryNodeValidationProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        ClusterNode locNode = this.ctx.discovery().localNode();
        String locBuildVer = (String)locNode.attribute("org.apache.ignite.build.ver");
        String rmtBuildVer = (String)node.attribute("org.apache.ignite.build.ver");
        if (!F.eq(rmtBuildVer, locBuildVer) && !locBuildVer.equals(rmtBuildVer)) {
            String errMsg = "Local node and remote node have different version numbers (node will not join, Ignite does not support rolling updates, so versions must be exactly the same) [locBuildVer=" + locBuildVer + ", rmtBuildVer=" + rmtBuildVer + ", locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + locNode.id() + ", rmtNodeId=" + node.id() + ']';
            LT.warn(this.log, errMsg);
            if (this.log.isDebugEnabled()) {
                this.log.debug(errMsg);
            }
            return new IgniteNodeValidationResult(node.id(), errMsg);
        }
        return null;
    }
}

