/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.cache.VisorCacheConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTaskArg;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteUuid;

public class VisorCacheConfigurationCollectorJob
extends VisorJob<VisorCacheConfigurationCollectorTaskArg, Map<String, VisorCacheConfiguration>> {
    private static final long serialVersionUID = 0L;

    public VisorCacheConfigurationCollectorJob(VisorCacheConfigurationCollectorTaskArg arg, boolean debug) {
        super(arg, debug);
    }

    @Override
    protected Map<String, VisorCacheConfiguration> run(VisorCacheConfigurationCollectorTaskArg arg) {
        Collection<IgniteCacheProxy<?, ?>> caches = this.ignite.context().cache().jcaches();
        Pattern ptrn = arg.getRegex() != null ? Pattern.compile(arg.getRegex()) : null;
        boolean all = F.isEmpty(arg.getCacheNames());
        boolean hasPtrn = ptrn != null;
        HashMap<String, VisorCacheConfiguration> res = U.newHashMap(caches.size());
        for (IgniteCacheProxy<?, ?> cache : caches) {
            boolean matched;
            if (!cache.context().userCache()) continue;
            String cacheName = cache.getName();
            boolean bl = hasPtrn ? ptrn.matcher(cacheName).find() : (matched = all || arg.getCacheNames().contains(cacheName));
            if (VisorTaskUtils.isRestartingCache(this.ignite, cacheName) || !matched) continue;
            VisorCacheConfiguration cfg = this.config(cache.getConfiguration(CacheConfiguration.class), cache.context().dynamicDeploymentId());
            res.put(cacheName, cfg);
        }
        return res;
    }

    protected VisorCacheConfiguration config(CacheConfiguration ccfg, IgniteUuid dynamicDeploymentId) {
        return new VisorCacheConfiguration(this.ignite, ccfg, dynamicDeploymentId);
    }

    public String toString() {
        return S.toString(VisorCacheConfigurationCollectorJob.class, this);
    }
}

