"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DmnEditorRoot = exports.EMPTY_DMN = exports.EXTERNAL_MODELS_SEARCH_GLOB_PATTERN = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var __path = require("path");
var React = require("react");
var react_1 = require("react");
var DmnEditor = require("@kie-tools/dmn-editor/dist/DmnEditor");
var normalize_1 = require("@kie-tools/dmn-editor/dist/normalization/normalize");
var dmn_marshaller_1 = require("@kie-tools/dmn-marshaller");
var api_1 = require("@kie-tools/boxed-expression-component/dist/api");
var api_2 = require("@kie-tools-core/workspace/dist/api");
var Dmn15Spec_1 = require("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec");
var xml_parser_ts_1 = require("@kie-tools/xml-parser-ts");
var meta_1 = require("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/meta");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var pmml_1 = require("@kie-tools/dmn-editor/dist/pmml/pmml");
var importNamespaces_1 = require("@kie-tools/dmn-editor/dist/includedModels/importNamespaces");
var useImperativePromiseHandler_1 = require("@kie-tools-core/react-hooks/dist/useImperativePromiseHandler");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var EmptyState_1 = require("@patternfly/react-core/dist/js/components/EmptyState");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
exports.EXTERNAL_MODELS_SEARCH_GLOB_PATTERN = "**/*.{dmn,pmml}";
var EMPTY_DMN = function () { return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<definitions\n  xmlns=\"".concat(meta_1.ns.get(""), "\"\n  expressionLanguage=\"").concat(Dmn15Spec_1.DMN15_SPEC.expressionLanguage.default, "\"\n  namespace=\"https://kie.org/dmn/").concat((0, api_1.generateUuid)(), "\"\n  id=\"").concat((0, api_1.generateUuid)(), "\"\n  name=\"DMN").concat((0, api_1.generateUuid)(), "\">\n</definitions>"); };
exports.EMPTY_DMN = EMPTY_DMN;
var DmnEditorRoot = (function (_super) {
    __extends(DmnEditorRoot, _super);
    function DmnEditorRoot(props) {
        var _this = _super.call(this, props) || this;
        _this.externalModelsManagerDoneBootstraping = (0, useImperativePromiseHandler_1.imperativePromiseHandle)();
        _this.setExternalModelsByNamespace = function (externalModelsByNamespace) {
            _this.setState(function (prev) { return (__assign(__assign({}, prev), { externalModelsByNamespace: externalModelsByNamespace })); });
        };
        _this.onModelChange = function (model) {
            _this.setState(function (prev) {
                var newStack = prev.stack.slice(0, prev.pointer + 1);
                return __assign(__assign({}, prev), { stack: __spreadArray(__spreadArray([], __read(newStack), false), [model], false), pointer: newStack.length });
            }, function () {
                return _this.props.onNewEdit({
                    id: "".concat(_this.state.openFilenormalizedPosixPathRelativeToTheWorkspaceRoot, "__").concat((0, api_1.generateUuid)()),
                });
            });
        };
        _this.onRequestExternalModelsAvailableToInclude = function () { return __awaiter(_this, void 0, void 0, function () {
            var list;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.state.openFilenormalizedPosixPathRelativeToTheWorkspaceRoot) {
                            return [2, []];
                        }
                        return [4, this.props.onRequestWorkspaceFilesList({
                                pattern: exports.EXTERNAL_MODELS_SEARCH_GLOB_PATTERN,
                                opts: { type: api_2.SearchType.TRAVERSAL },
                            })];
                    case 1:
                        list = _a.sent();
                        return [2, list.normalizedPosixPathsRelativeToTheWorkspaceRoot.flatMap(function (p) {
                                return p === _this.state.openFilenormalizedPosixPathRelativeToTheWorkspaceRoot
                                    ? []
                                    : __path.relative(__path.dirname(_this.state.openFilenormalizedPosixPathRelativeToTheWorkspaceRoot), p);
                            })];
                }
            });
        }); };
        _this.onRequestToResolvePathRelativeToTheOpenFile = function (normalizedPosixPathRelativeToTheOpenFile) {
            var normalizedPosixPathRelativeToTheWorkspaceRoot = __path
                .resolve(__path.dirname(_this.state.openFilenormalizedPosixPathRelativeToTheWorkspaceRoot), normalizedPosixPathRelativeToTheOpenFile)
                .substring(1);
            return normalizedPosixPathRelativeToTheWorkspaceRoot;
        };
        _this.onRequestExternalModelByPathsRelativeToTheOpenFile = function (normalizedPosixPathRelativeToTheOpenFile) { return __awaiter(_this, void 0, void 0, function () {
            var normalizedPosixPathRelativeToTheWorkspaceRoot, resource, ext;
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        normalizedPosixPathRelativeToTheWorkspaceRoot = this.onRequestToResolvePathRelativeToTheOpenFile(normalizedPosixPathRelativeToTheOpenFile);
                        return [4, this.props.onRequestWorkspaceFileContent({
                                normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
                                opts: { type: api_2.ContentType.TEXT },
                            })];
                    case 1:
                        resource = _c.sent();
                        ext = __path.extname(normalizedPosixPathRelativeToTheOpenFile);
                        if (ext === ".dmn") {
                            return [2, {
                                    normalizedPosixPathRelativeToTheOpenFile: normalizedPosixPathRelativeToTheOpenFile,
                                    type: "dmn",
                                    model: (0, normalize_1.normalize)((0, dmn_marshaller_1.getMarshaller)((_a = resource === null || resource === void 0 ? void 0 : resource.content) !== null && _a !== void 0 ? _a : "", { upgradeTo: "latest" }).parser.parse()),
                                    svg: "",
                                }];
                        }
                        else if (ext === ".pmml") {
                            return [2, {
                                    normalizedPosixPathRelativeToTheOpenFile: normalizedPosixPathRelativeToTheOpenFile,
                                    type: "pmml",
                                    model: (0, pmml_editor_marshaller_1.XML2PMML)((_b = resource === null || resource === void 0 ? void 0 : resource.content) !== null && _b !== void 0 ? _b : ""),
                                }];
                        }
                        else {
                            throw new Error("Unknown extension '".concat(ext, "'."));
                        }
                        return [2];
                }
            });
        }); };
        _this.onOpenFileFromPathRelativeToTheOpenFile = function (normalizedPosixPathRelativeToTheOpenFile) {
            if (!_this.state.openFilenormalizedPosixPathRelativeToTheWorkspaceRoot) {
                return;
            }
            _this.props.onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot(_this.onRequestToResolvePathRelativeToTheOpenFile(normalizedPosixPathRelativeToTheOpenFile));
        };
        props.exposing(_this);
        _this.dmnEditorRef = React.createRef();
        _this.state = {
            externalModelsByNamespace: {},
            marshaller: undefined,
            stack: [],
            pointer: -1,
            openFilenormalizedPosixPathRelativeToTheWorkspaceRoot: undefined,
            readonly: true,
            externalModelsManagerDoneBootstraping: false,
            keyboardShortcutsRegisterIds: [],
            keyboardShortcutsRegistred: false,
            error: undefined,
        };
        return _this;
    }
    DmnEditorRoot.prototype.undo = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.setState(function (prev) { return (__assign(__assign({}, prev), { pointer: Math.max(0, prev.pointer - 1) })); });
                return [2];
            });
        });
    };
    DmnEditorRoot.prototype.redo = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.setState(function (prev) { return (__assign(__assign({}, prev), { pointer: Math.min(prev.stack.length - 1, prev.pointer + 1) })); });
                return [2];
            });
        });
    };
    DmnEditorRoot.prototype.getDiagramSvg = function () {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                return [2, (_a = this.dmnEditorRef.current) === null || _a === void 0 ? void 0 : _a.getDiagramSvg()];
            });
        });
    };
    DmnEditorRoot.prototype.getContent = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (!this.state.marshaller || !this.model) {
                    throw new Error("DMN EDITOR ROOT: Content has not been set yet. Throwing an error to prevent returning a \"default\" content.");
                }
                return [2, this.state.marshaller.builder.build(this.model)];
            });
        });
    };
    DmnEditorRoot.prototype.setContent = function (openFilenormalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        return __awaiter(this, void 0, void 0, function () {
            var marshaller, savedStackPointer;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        marshaller = this.getMarshaller(content);
                        savedStackPointer = [];
                        this.setState(function (prev) {
                            savedStackPointer = __spreadArray([], __read(prev.stack), false);
                            return {
                                stack: [(0, normalize_1.normalize)(marshaller.parser.parse())],
                                openFilenormalizedPosixPathRelativeToTheWorkspaceRoot: openFilenormalizedPosixPathRelativeToTheWorkspaceRoot,
                                pointer: 0,
                            };
                        });
                        return [4, this.externalModelsManagerDoneBootstraping.promise];
                    case 1:
                        _a.sent();
                        this.setState(function (prev) {
                            if (prev.openFilenormalizedPosixPathRelativeToTheWorkspaceRoot ===
                                openFilenormalizedPosixPathRelativeToTheWorkspaceRoot) {
                                var newStack = savedStackPointer.slice(0, prev.pointer + 1);
                                return {
                                    marshaller: marshaller,
                                    openFilenormalizedPosixPathRelativeToTheWorkspaceRoot: openFilenormalizedPosixPathRelativeToTheWorkspaceRoot,
                                    stack: __spreadArray(__spreadArray([], __read(newStack), false), [(0, normalize_1.normalize)(marshaller.parser.parse())], false),
                                    readonly: false,
                                    pointer: newStack.length,
                                    externalModelsManagerDoneBootstraping: true,
                                };
                            }
                            else {
                                return {
                                    marshaller: marshaller,
                                    openFilenormalizedPosixPathRelativeToTheWorkspaceRoot: openFilenormalizedPosixPathRelativeToTheWorkspaceRoot,
                                    stack: [(0, normalize_1.normalize)(marshaller.parser.parse())],
                                    readonly: false,
                                    pointer: 0,
                                    externalModelsManagerDoneBootstraping: true,
                                };
                            }
                        });
                        return [2];
                }
            });
        });
    };
    Object.defineProperty(DmnEditorRoot.prototype, "model", {
        get: function () {
            return this.state.stack[this.state.pointer];
        },
        enumerable: false,
        configurable: true
    });
    DmnEditorRoot.prototype.getMarshaller = function (content) {
        try {
            return (0, dmn_marshaller_1.getMarshaller)(content || (0, exports.EMPTY_DMN)(), { upgradeTo: "latest" });
        }
        catch (e) {
            this.setState(function (s) { return (__assign(__assign({}, s), { error: e })); });
            throw e;
        }
    };
    DmnEditorRoot.prototype.componentDidUpdate = function (prevProps, prevState, snapshot) {
        var _this = this;
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        if (this.props.keyboardShortcutsService === undefined || this.state.keyboardShortcutsRegistred === true) {
            return;
        }
        var commands = (_a = this.dmnEditorRef.current) === null || _a === void 0 ? void 0 : _a.getCommands();
        if (commands === undefined) {
            return;
        }
        var cancelAction = this.props.keyboardShortcutsService.registerKeyPress("Escape", "Edit | Unselect", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.cancelAction()];
        }); }); });
        var deleteSelectionBackspace = this.props.keyboardShortcutsService.registerKeyPress("Backspace", "Edit | Delete selection", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var deleteSelectionDelete = this.props.keyboardShortcutsService.registerKeyPress("Delete", "Edit | Delete selection", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var selectAll = (_b = this.props.keyboardShortcutsService) === null || _b === void 0 ? void 0 : _b.registerKeyPress("A", "Edit | Select/Deselect all", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.selectAll()];
        }); }); });
        var createGroup = (_c = this.props.keyboardShortcutsService) === null || _c === void 0 ? void 0 : _c.registerKeyPress("G", "Edit | Create group wrapping selection", function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                console.log(" KEY GROUP PRESSED, ", commands);
                return [2, commands.createGroup()];
            });
        }); });
        var hideFromDrd = (_d = this.props.keyboardShortcutsService) === null || _d === void 0 ? void 0 : _d.registerKeyPress("X", "Edit | Hide from DRD", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.hideFromDrd()];
        }); }); });
        var copy = (_e = this.props.keyboardShortcutsService) === null || _e === void 0 ? void 0 : _e.registerKeyPress("Ctrl+C", "Edit | Copy nodes", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.copy()];
        }); }); });
        var cut = (_f = this.props.keyboardShortcutsService) === null || _f === void 0 ? void 0 : _f.registerKeyPress("Ctrl+X", "Edit | Cut nodes", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.cut()];
        }); }); });
        var paste = (_g = this.props.keyboardShortcutsService) === null || _g === void 0 ? void 0 : _g.registerKeyPress("Ctrl+V", "Edit | Paste nodes", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.paste()];
        }); }); });
        var togglePropertiesPanel = (_h = this.props.keyboardShortcutsService) === null || _h === void 0 ? void 0 : _h.registerKeyPress("I", "Misc | Open/Close properties panel", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.togglePropertiesPanel()];
        }); }); });
        var toggleHierarchyHighlight = (_j = this.props.keyboardShortcutsService) === null || _j === void 0 ? void 0 : _j.registerKeyPress("H", "Misc | Toggle hierarchy highlights", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.toggleHierarchyHighlight()];
        }); }); });
        var moveUp = this.props.keyboardShortcutsService.registerKeyPress("Up", "Move | Move selection up", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var moveDown = this.props.keyboardShortcutsService.registerKeyPress("Down", "Move | Move selection down", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var moveLeft = this.props.keyboardShortcutsService.registerKeyPress("Left", "Move | Move selection left", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var moveRight = this.props.keyboardShortcutsService.registerKeyPress("Right", "Move | Move selection right", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var bigMoveUp = this.props.keyboardShortcutsService.registerKeyPress("Shift + Up", "Move | Move selection up a big distance", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var bigMoveDown = this.props.keyboardShortcutsService.registerKeyPress("Shift + Down", "Move | Move selection down a big distance", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var bigMoveLeft = this.props.keyboardShortcutsService.registerKeyPress("Shift + Left", "Move | Move selection left a big distance", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var bigMoveRight = this.props.keyboardShortcutsService.registerKeyPress("Shift + Right", "Move | Move selection right a big distance", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var focusOnBounds = (_k = this.props.keyboardShortcutsService) === null || _k === void 0 ? void 0 : _k.registerKeyPress("B", "Navigate | Focus on selection", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.focusOnSelection()];
        }); }); });
        var resetPosition = (_l = this.props.keyboardShortcutsService) === null || _l === void 0 ? void 0 : _l.registerKeyPress("Space", "Navigate | Reset position to origin", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, commands.resetPosition()];
        }); }); });
        var pan = (_m = this.props.keyboardShortcutsService) === null || _m === void 0 ? void 0 : _m.registerKeyPress("Right Mouse Button", "Navigate | Hold and drag to Pan", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var zoom = (_o = this.props.keyboardShortcutsService) === null || _o === void 0 ? void 0 : _o.registerKeyPress("Ctrl", "Navigate | Hold and scroll to zoom in/out", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        var navigateHorizontally = (_p = this.props.keyboardShortcutsService) === null || _p === void 0 ? void 0 : _p.registerKeyPress("Shift", "Navigate | Hold and scroll to navigate horizontally", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2];
        }); }); });
        this.setState(function (prev) { return (__assign(__assign({}, prev), { keyboardShortcutsRegistred: true, keyboardShortcutsRegisterIds: [
                bigMoveDown,
                bigMoveLeft,
                bigMoveRight,
                bigMoveUp,
                cancelAction,
                copy,
                createGroup,
                cut,
                deleteSelectionBackspace,
                deleteSelectionDelete,
                focusOnBounds,
                hideFromDrd,
                moveDown,
                moveLeft,
                moveRight,
                moveUp,
                navigateHorizontally,
                pan,
                paste,
                resetPosition,
                selectAll,
                toggleHierarchyHighlight,
                togglePropertiesPanel,
                zoom,
            ] })); });
    };
    DmnEditorRoot.prototype.componentWillUnmount = function () {
        var _this = this;
        var _a;
        var keyboardShortcuts = (_a = this.dmnEditorRef.current) === null || _a === void 0 ? void 0 : _a.getCommands();
        if (keyboardShortcuts === undefined) {
            return;
        }
        this.state.keyboardShortcutsRegisterIds.forEach(function (id) {
            var _a;
            (_a = _this.props.keyboardShortcutsService) === null || _a === void 0 ? void 0 : _a.deregister(id);
        });
    };
    DmnEditorRoot.prototype.render = function () {
        var _a;
        return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [this.state.error && (0, jsx_runtime_1.jsx)(DmnMarshallerFallbackError, { error: this.state.error }), this.model && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)(DmnEditor.DmnEditor, { ref: this.dmnEditorRef, originalVersion: (_a = this.state.marshaller) === null || _a === void 0 ? void 0 : _a.originalVersion, model: this.model, externalModelsByNamespace: this.state.externalModelsByNamespace, evaluationResults: [], validationMessages: [], externalContextName: "", externalContextDescription: "", issueTrackerHref: "", onModelChange: this.onModelChange, onRequestExternalModelsAvailableToInclude: this.onRequestExternalModelsAvailableToInclude, onRequestExternalModelByPath: this.onRequestExternalModelByPathsRelativeToTheOpenFile, onRequestToJumpToPath: this.onOpenFileFromPathRelativeToTheOpenFile, onRequestToResolvePath: this.onRequestToResolvePathRelativeToTheOpenFile }), (0, jsx_runtime_1.jsx)(ExternalModelsManager, { workspaceRootAbsolutePosixPath: this.props.workspaceRootAbsolutePosixPath, thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot: this.state.openFilenormalizedPosixPathRelativeToTheWorkspaceRoot, model: this.model, onChange: this.setExternalModelsByNamespace, onRequestWorkspaceFilesList: this.props.onRequestWorkspaceFilesList, onRequestWorkspaceFileContent: this.props.onRequestWorkspaceFileContent, externalModelsManagerDoneBootstraping: this.externalModelsManagerDoneBootstraping })] }))] }));
    };
    return DmnEditorRoot;
}(React.Component));
exports.DmnEditorRoot = DmnEditorRoot;
var NAMESPACES_EFFECT_SEPARATOR = " , ";
function ExternalModelsManager(_a) {
    var workspaceRootAbsolutePosixPath = _a.workspaceRootAbsolutePosixPath, thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot = _a.thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot, model = _a.model, onChange = _a.onChange, onRequestWorkspaceFileContent = _a.onRequestWorkspaceFileContent, onRequestWorkspaceFilesList = _a.onRequestWorkspaceFilesList, externalModelsManagerDoneBootstraping = _a.externalModelsManagerDoneBootstraping;
    var namespaces = (0, react_1.useMemo)(function () {
        var _a;
        return ((_a = model.definitions.import) !== null && _a !== void 0 ? _a : [])
            .map(function (i) { return (0, importNamespaces_1.getNamespaceOfDmnImport)({ dmnImport: i }); })
            .join(NAMESPACES_EFFECT_SEPARATOR);
    }, [model.definitions.import]);
    var _b = __read((0, react_1.useState)(0), 2), externalUpdatesCount = _b[0], setExternalUpdatesCount = _b[1];
    (0, react_1.useEffect)(function () {
        var bc = new BroadcastChannel("workspaces_files");
        bc.onmessage = function (_a) {
            var data = _a.data;
            if ((data === null || data === void 0 ? void 0 : data.relativePath) === thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                return;
            }
            setExternalUpdatesCount(function (prev) { return prev + 1; });
        };
        return function () {
            bc.close();
        };
    }, [thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot]);
    (0, react_1.useEffect)(function () {
        var canceled = false;
        if (!thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot) {
            return;
        }
        onRequestWorkspaceFilesList({ pattern: exports.EXTERNAL_MODELS_SEARCH_GLOB_PATTERN, opts: { type: api_2.SearchType.TRAVERSAL } })
            .then(function (list) {
            var resources = [];
            for (var i = 0; i < list.normalizedPosixPathsRelativeToTheWorkspaceRoot.length; i++) {
                var normalizedPosixPathRelativeToTheWorkspaceRoot = list.normalizedPosixPathsRelativeToTheWorkspaceRoot[i];
                if (normalizedPosixPathRelativeToTheWorkspaceRoot === thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                    continue;
                }
                resources.push(onRequestWorkspaceFileContent({
                    normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
                    opts: { type: api_2.ContentType.TEXT },
                }));
            }
            return Promise.all(resources);
        })
            .then(function (resources) {
            var _a;
            var externalModelsIndex = {};
            var namespacesSet = new Set(namespaces.split(NAMESPACES_EFFECT_SEPARATOR));
            for (var i = 0; i < resources.length; i++) {
                var resource = resources[i];
                if (!resource) {
                    continue;
                }
                var content = (_a = resource.content) !== null && _a !== void 0 ? _a : "";
                var normalizedPosixPathRelativeToTheOpenFile = __path.relative(__path.dirname(thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot), resource.normalizedPosixPathRelativeToTheWorkspaceRoot);
                var ext = __path.extname(resource.normalizedPosixPathRelativeToTheWorkspaceRoot);
                if (ext === ".dmn") {
                    var namespace = xml_parser_ts_1.domParser.getDomDocument(content).documentElement.getAttribute("namespace");
                    if (namespace && namespacesSet.has(namespace)) {
                        if (externalModelsIndex[namespace]) {
                            console.warn("DMN EDITOR ROOT: Multiple DMN models encountered with the same namespace '".concat(namespace, "': '").concat(resource.normalizedPosixPathRelativeToTheWorkspaceRoot, "' and '").concat(externalModelsIndex[namespace].normalizedPosixPathRelativeToTheOpenFile, "'. The latter will be considered."));
                        }
                        externalModelsIndex[namespace] = {
                            normalizedPosixPathRelativeToTheOpenFile: normalizedPosixPathRelativeToTheOpenFile,
                            model: (0, normalize_1.normalize)((0, dmn_marshaller_1.getMarshaller)(content, { upgradeTo: "latest" }).parser.parse()),
                            type: "dmn",
                            svg: "",
                        };
                    }
                }
                else if (ext === ".pmml") {
                    var namespace = (0, pmml_1.getPmmlNamespace)({ normalizedPosixPathRelativeToTheOpenFile: normalizedPosixPathRelativeToTheOpenFile });
                    if (namespace && namespacesSet.has(namespace)) {
                        externalModelsIndex[namespace] = {
                            normalizedPosixPathRelativeToTheOpenFile: normalizedPosixPathRelativeToTheOpenFile,
                            model: (0, pmml_editor_marshaller_1.XML2PMML)(content),
                            type: "pmml",
                        };
                    }
                }
                else {
                    throw new Error("Unknown extension '".concat(ext, "'."));
                }
            }
            if (!canceled) {
                onChange(externalModelsIndex);
            }
            externalModelsManagerDoneBootstraping.resolve();
        });
        return function () {
            canceled = true;
        };
    }, [
        namespaces,
        onChange,
        onRequestWorkspaceFileContent,
        onRequestWorkspaceFilesList,
        thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot,
        externalUpdatesCount,
        workspaceRootAbsolutePosixPath,
        externalModelsManagerDoneBootstraping,
    ]);
    return (0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {});
}
function DmnMarshallerFallbackError(_a) {
    var error = _a.error;
    return ((0, jsx_runtime_1.jsx)(Flex_1.Flex, __assign({ justifyContent: { default: "justifyContentCenter" }, style: { marginTop: "100px" } }, { children: (0, jsx_runtime_1.jsxs)(EmptyState_1.EmptyState, __assign({ style: { maxWidth: "1280px" } }, { children: [(0, jsx_runtime_1.jsx)(EmptyState_1.EmptyStateIcon, { icon: function () { return (0, jsx_runtime_1.jsx)("div", __assign({ style: { fontSize: "3em" } }, { children: "\uD83D\uDE15" })); } }), (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ size: "lg", headingLevel: "h4" }, { children: "Unable to open file." })), (0, jsx_runtime_1.jsx)("br", {}), (0, jsx_runtime_1.jsxs)(EmptyState_1.EmptyStateBody, { children: ["Error details: ", error.message] })] })) })));
}
//# sourceMappingURL=DmnEditorRoot.js.map