export declare enum TitleType {
    SUCCESS = "success",
    FAILURE = "failure"
}
export declare enum MilestoneStatus {
    Available = "AVAILABLE",
    Active = "ACTIVE",
    Completed = "COMPLETED"
}
export interface NodeInstance {
    __typename?: "NodeInstance";
    id: string;
    name: string;
    type: string;
    enter: Date;
    exit?: Date;
    definitionId: string;
    nodeId: string;
}
export interface TriggerableNode {
    id: string;
    name: string;
    type: string;
}
export interface Milestone {
    __typename?: "Milestone";
    id: string;
    name: string;
    status: MilestoneStatus;
}
export declare enum OrderBy {
    ASC = "ASC",
    DESC = "DESC"
}
export interface SvgSuccessResponse {
    svg: string;
    error?: never;
}
export interface SvgErrorResponse {
    error: string;
    svg?: never;
}
export declare type JsonType = {
    [key: string]: string | number | boolean;
};
export declare enum SCHEMA_VERSION {
    DRAFT_7 = "http://json-schema.org/draft-07/schema#",
    DRAFT_2019_09 = "https://json-schema.org/draft/2019-09/schema"
}
export declare enum OperationType {
    ABORT = "ABORT",
    SKIP = "SKIP",
    RETRY = "RETRY",
    CANCEL = "CANCEL"
}
export declare const KOGITO_PROCESS_REFERENCE_ID = "kogitoprocrefid";
export declare const KOGITO_BUSINESS_KEY = "kogitobusinesskey";
export interface CustomDashboardInfo {
    name: string;
    path: string;
    lastModified: Date;
}
export interface FormResources {
    scripts: {
        [key: string]: string;
    };
    styles: {
        [key: string]: string;
    };
}
export declare enum FormType {
    HTML = "HTML",
    TSX = "TSX"
}
interface FormConfiguration {
    schema: string;
    resources: FormResources;
}
export interface Form {
    formInfo: FormInfo;
    source: string;
    configuration: FormConfiguration;
}
export interface FormContent {
    source: string;
    configuration: FormConfiguration;
}
export interface FormInfo {
    name: string;
    type: FormType;
    lastModified: Date;
}
export {};
//# sourceMappingURL=types.d.ts.map