var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
export class ProcessDetailsGatewayApiImpl {
    constructor(queries) {
        this.listeners = [];
        this.getProcessDiagram = (data) => __awaiter(this, void 0, void 0, function* () {
            const result = yield this.queries.getSVG(data);
            return Promise.resolve(result);
        });
        this.handleProcessAbort = (processInstance) => {
            return this.queries.handleProcessAbort(processInstance);
        };
        this.cancelJob = (job) => {
            return this.queries.jobCancel(job);
        };
        this.rescheduleJob = (job, repeatInterval, repeatLimit, scheduleDate) => {
            return this.queries.rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate);
        };
        this.handleProcessVariableUpdate = (processInstance, updatedJson) => {
            return this.queries.handleProcessVariableUpdate(processInstance, updatedJson);
        };
        this.queries = queries;
        this._ProcessDetailsState = { id: "" };
    }
    get processDetailsState() {
        return this._ProcessDetailsState;
    }
    getTriggerableNodes(processInstance) {
        return this.queries.getTriggerableNodes(processInstance);
    }
    handleNodeTrigger(processInstance, node) {
        return this.queries.handleNodeTrigger(processInstance, node);
    }
    processDetailsQuery(id) {
        return new Promise((resolve, reject) => {
            this.queries
                .getProcessDetails(id)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    jobsQuery(id) {
        return new Promise((resolve, reject) => {
            this.queries
                .getJobs(id)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    openProcessInstanceDetails(id) {
        this._ProcessDetailsState = { id: id };
        this.listeners.forEach((listener) => listener.onOpen(id));
        return Promise.resolve();
    }
    onOpenProcessInstanceDetailsListener(listener) {
        this.listeners.push(listener);
        const unSubscribe = () => {
            const index = this.listeners.indexOf(listener);
            if (index > -1) {
                this.listeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    handleProcessRetry(processInstance) {
        return this.queries.handleProcessRetry(processInstance);
    }
    handleNodeInstanceCancel(processInstance, node) {
        return this.queries.handleNodeInstanceCancel(processInstance, node);
    }
    handleProcessSkip(processInstance) {
        return this.queries.handleProcessSkip(processInstance);
    }
    handleNodeInstanceRetrigger(processInstance, node) {
        return this.queries.handleNodeInstanceRetrigger(processInstance, node);
    }
}
//# sourceMappingURL=ProcessDetailsGatewayApi.js.map