import React from "react";
import TaskInboxContext from "./TaskInboxContext";
import { TaskInboxGatewayApiImpl } from "./TaskInboxGatewayApi";
import { GraphQLTaskInboxQueries } from "./TaskInboxQueries";
import { useKogitoAppContext } from "@kie-tools/runtime-tools-components/dist/contexts/KogitoAppContext";
export const TaskInboxContextProvider = ({ apolloClient, children }) => {
    const appContext = useKogitoAppContext();
    return (React.createElement(TaskInboxContext.Provider, { value: new TaskInboxGatewayApiImpl(new GraphQLTaskInboxQueries(apolloClient), () => appContext.getCurrentUser()) }, children));
};
export default TaskInboxContextProvider;
//# sourceMappingURL=TaskInboxContextProvider.js.map