import { QueryFilter, SortBy, TaskInboxState } from "@kie-tools/runtime-tools-process-enveloped-components/src/taskInbox";
import { TaskInboxQueries } from "./TaskInboxQueries";
import { UserTaskInstance } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { User } from "@kie-tools/runtime-tools-components/dist/contexts/KogitoAppContext";
export interface TaskInboxGatewayApi {
    taskInboxState: TaskInboxState;
    setInitialState: (initialState: TaskInboxState) => Promise<void>;
    applyFilter(filter: QueryFilter): Promise<void>;
    applySorting(sortBy: SortBy): Promise<void>;
    query(offset: number, limit: number): Promise<UserTaskInstance[]>;
    getTaskById(uuid: string): Promise<UserTaskInstance | undefined>;
    openTask: (userTask: UserTaskInstance) => void;
    clearOpenTask: () => Promise<void>;
    onOpenTaskListen: (listener: OnOpenTaskListener) => UnSubscribeHandler;
}
export interface OnOpenTaskListener {
    onOpen: (userTask: UserTaskInstance) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class TaskInboxGatewayApiImpl implements TaskInboxGatewayApi {
    private readonly listeners;
    private getCurrentUser;
    private readonly queries;
    private _taskInboxState;
    private activeTask;
    constructor(queries: TaskInboxQueries, getCurrentUser: () => User);
    get taskInboxState(): TaskInboxState;
    setInitialState(taskInboxState: TaskInboxState): Promise<void>;
    clearOpenTask(): Promise<void>;
    openTask(task: UserTaskInstance): Promise<void>;
    applyFilter(filter: QueryFilter): Promise<void>;
    applySorting(sortBy: SortBy): Promise<void>;
    getTaskById(taskId: string): Promise<UserTaskInstance | undefined>;
    query(offset: number, limit: number): Promise<UserTaskInstance[]>;
    onOpenTaskListen(listener: OnOpenTaskListener): UnSubscribeHandler;
}
//# sourceMappingURL=TaskInboxGatewayApi.d.ts.map