import { GraphQL } from "@kie-tools/runtime-tools-process-gateway-api/dist/graphql";
import { buildTaskInboxWhereArgument, getOrderByObject } from "../utils/QueryUtils";
export class GraphQLTaskInboxQueries {
    constructor(client) {
        this.client = client;
    }
    getUserTaskById(taskId) {
        return new Promise((resolve, reject) => {
            this.client
                .query({
                query: GraphQL.GetUserTaskByIdDocument,
                variables: {
                    id: taskId,
                },
                fetchPolicy: "network-only",
            })
                .then((value) => {
                if (value.data.UserTaskInstances && value.data.UserTaskInstances.length > 0) {
                    resolve(value.data.UserTaskInstances[0]);
                    return;
                }
                resolve(undefined);
            })
                .catch((reason) => reject(reason));
        });
    }
    getUserTasks(user, offset, limit, filters, sortBy) {
        return new Promise((resolve, reject) => {
            this.client
                .query({
                query: GraphQL.GetTasksForUserDocument,
                variables: {
                    whereArgument: buildTaskInboxWhereArgument(user, filters),
                    offset: offset,
                    limit: limit,
                    orderBy: getOrderByObject(sortBy),
                },
                fetchPolicy: "network-only",
            })
                .then((value) => {
                resolve(value.data.UserTaskInstances);
            })
                .catch((reason) => reject(reason));
        });
    }
}
//# sourceMappingURL=TaskInboxQueries.js.map