"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isOfKind = exports.FileTypes = void 0;
var REGEX = {
    supportedSingleExtensions: /(\.bpmn|bpmn2|\.dmn|\.pmml)$/i,
    supportedDoubleExtensions: /(\.sw\.(json|yml|yaml)|\.yard\.(json|yml|yaml)|\.dash\.(yml|yaml))$/i,
    sw: /^.*\.sw\.(json|yml|yaml)$/i,
    swJson: /^.*\.sw\.json$/i,
    swYaml: /^.*\.sw\.yaml$/i,
    yard: /^.*\.yard\.(yml|yaml)$/i,
    dash: /^.*\.dash\.(yml|yaml)$/i,
    dmn: /^.*\.dmn$/i,
    bpmn: /^.*\.(bpmn|bpmn2)$/i,
    scesim: /^.*\.scesim$/i,
    pmml: /^.*\.pmml$/i,
    json: /^.*\.json$/i,
    yaml: /^.*\.(yml|yaml)$/i,
    spec: /^.*(\.spec|\.specs|spec|specs)\.(json|yml|yaml)$/i,
};
var FileTypes;
(function (FileTypes) {
    FileTypes["SW_JSON"] = "sw.json";
    FileTypes["SW_YML"] = "sw.yml";
    FileTypes["SW_YAML"] = "sw.yaml";
    FileTypes["YARD_JSON"] = "yard.json";
    FileTypes["YARD_YML"] = "yard.yml";
    FileTypes["YARD_YAML"] = "yard.yaml";
    FileTypes["DASH_YAML"] = "dash.yaml";
    FileTypes["DASH_YML"] = "dash.yml";
    FileTypes["DMN"] = "dmn";
    FileTypes["BPMN"] = "bpmn";
    FileTypes["BPMN2"] = "bpmn2";
    FileTypes["SCESIM"] = "scesim";
    FileTypes["PMML"] = "pmml";
})(FileTypes = exports.FileTypes || (exports.FileTypes = {}));
var matchers = {};
var _loop_1 = function (key) {
    var kind = key;
    matchers[kind] = function (path) { return REGEX[kind].test(path); };
};
for (var key in REGEX) {
    _loop_1(key);
}
function isOfKind(kind, path) {
    return matchers[kind](path);
}
exports.isOfKind = isOfKind;
//# sourceMappingURL=ExtensionHelper.js.map