import { FetchResult } from "isomorphic-git";
import { KieSandboxWorkspacesFs } from "./KieSandboxWorkspaceFs";
export interface CloneArgs {
    fs: KieSandboxWorkspacesFs;
    repositoryUrl: URL;
    sourceBranch: string;
    dir: string;
    gitConfig?: {
        name: string;
        email: string;
    };
    authInfo?: {
        username: string;
        password: string;
    };
    insecurelyDisableTlsCertificateValidation?: boolean;
}
export interface CommitArgs {
    fs: KieSandboxWorkspacesFs;
    message: string;
    targetBranch: string;
    dir: string;
    author: {
        name: string;
        email: string;
    };
}
export interface PushArgs {
    fs: KieSandboxWorkspacesFs;
    dir: string;
    ref: string;
    remoteRef?: string;
    remote: string;
    force: boolean;
    authInfo: {
        username: string;
        password: string;
    };
    insecurelyDisableTlsCertificateValidation?: boolean;
}
export interface RemoteRefArgs {
    fs: KieSandboxWorkspacesFs;
    dir: string;
    remoteRef?: string;
    authInfo?: {
        username: string;
        password: string;
    };
    insecurelyDisableTlsCertificateValidation?: boolean;
}
export declare enum FileModificationStatus {
    added = "added",
    modified = "modified",
    deleted = "deleted"
}
export declare type UnstagedModifiedFilesStatusEntryType = {
    path: string;
    status: FileModificationStatus;
};
export declare class GitService {
    private readonly corsProxy;
    constructor(corsProxy: Promise<string>);
    private getRequestHeaders;
    listServerRefs(args: {
        url: string;
        authInfo?: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<import("isomorphic-git").ServerRef[]>;
    clone(args: CloneArgs): Promise<void>;
    branch(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        name: string;
        checkout: boolean;
    }): Promise<void>;
    addRemote(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        name: string;
        url: string;
        force: boolean;
    }): Promise<void>;
    deleteRemote(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        name: string;
    }): Promise<void>;
    fetch(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        remote: string;
        ref: string;
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<FetchResult>;
    checkout(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        ref: string;
        remote: string;
    }): Promise<void>;
    checkoutFilesFromLocalHead(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        ref?: string;
        filepaths: string[];
    }): Promise<void>;
    commit(args: CommitArgs): Promise<void>;
    pull(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        ref: string;
        author: {
            name: string;
            email: string;
        };
        authInfo?: {
            username: string;
            password: string;
        };
        insecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<void>;
    deleteBranch(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        ref: string;
    }): Promise<void>;
    getRemoteRef(args: RemoteRefArgs): Promise<import("isomorphic-git").ServerRef | undefined>;
    push(args: PushArgs): Promise<void>;
    add(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        relativePath: string;
    }): Promise<void>;
    setupGitConfig(fs: KieSandboxWorkspacesFs, dir: string, config: {
        name: string;
        email: string;
    }): Promise<void>;
    init(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
    }): Promise<void>;
    isIgnored(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        filepath: string;
    }): Promise<boolean>;
    rm(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        relativePath: string;
    }): Promise<void>;
    isModified(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        relativePath: string;
    }): Promise<boolean>;
    hasLocalChanges(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        exclude: (filepath: string) => boolean;
    }): Promise<boolean>;
    unstagedModifiedFilesStatus(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        exclude: (filepath: string) => boolean;
    }): Promise<UnstagedModifiedFilesStatusEntryType[]>;
    resolveRef(args: {
        fs: KieSandboxWorkspacesFs;
        dir: string;
        ref: string;
    }): Promise<string>;
}
//# sourceMappingURL=GitService.d.ts.map