import { AllExpressionTypes, AllExpressions, AllExpressionsWithoutTypes } from "../dataTypes/DataTypeSpec";
interface PathType {
    type: AllExpressionTypes;
    root: string;
}
interface ConditionalExpressionPath extends PathType {
    type: "conditional";
    row?: "if" | "else" | "then";
}
interface ContextExpressionPath extends PathType {
    type: "context";
    row?: number;
    column?: "variable" | "expression";
}
interface DecisionTablePath extends PathType {
    type: "decisionTable";
    header?: "input" | "output";
    row?: number;
    column?: number;
}
interface EveryExpressionPath extends PathType {
    type: "every";
    row?: "variable" | "in" | "statisfies";
}
interface FilterExpressionPath extends PathType {
    type: "filter";
    row?: "in" | "match";
}
interface ForExpressionPath extends PathType {
    type: "for";
    row?: "variable" | "in" | "return";
}
interface FunctionDefinitionExpressionPath extends PathType {
    type: "functionDefinition";
    parameterIndex?: number;
}
interface InvocationExpressionPath extends PathType {
    type: "invocation";
    row?: number;
    column?: "parameter" | "expression";
}
interface ListExpressionPath extends PathType {
    type: "list";
    row?: number;
}
interface LiteralExpressionPath extends PathType {
    type: "literalExpression";
}
interface RelationExpressionPath extends PathType {
    type: "relation";
    row?: number;
    column?: number;
}
interface SomeExpressionPath extends PathType {
    type: "some";
    row?: "variable" | "in" | "statisfies";
}
export declare type ExpressionPath = ConditionalExpressionPath | ContextExpressionPath | DecisionTablePath | EveryExpressionPath | FilterExpressionPath | ForExpressionPath | FunctionDefinitionExpressionPath | InvocationExpressionPath | ListExpressionPath | LiteralExpressionPath | RelationExpressionPath | SomeExpressionPath;
export declare type BoxedExpressionIndex = Map<string, {
    expressionPath: ExpressionPath[];
    cell: AllExpressionsWithoutTypes | AllExpressionsWithoutTypes[];
}>;
export declare function generateBoxedExpressionIndex(expression: AllExpressions, parentMap: BoxedExpressionIndex, parentExpressionPath: ExpressionPath[]): BoxedExpressionIndex;
export declare function getDmnObjectByPath(paths: ExpressionPath[], expressionRoot?: AllExpressionsWithoutTypes): AllExpressionsWithoutTypes | undefined;
export {};
//# sourceMappingURL=boxedExpressionIndex.d.ts.map