var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
export function generateBoxedExpressionIndex(expression, parentMap, parentExpressionPath) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    var map = parentMap ? parentMap : new Map();
    switch (expression === null || expression === void 0 ? void 0 : expression.__$$element) {
        case "conditional":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "conditional", root: expression["@_id"] }], false),
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.if.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "conditional", row: "if", root: expression["@_id"] },
            ], false));
            generateBoxedExpressionIndex(expression.else.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "conditional", row: "else", root: expression["@_id"] },
            ], false));
            generateBoxedExpressionIndex(expression.then.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "conditional", row: "then", root: expression["@_id"] },
            ], false));
            return map;
        case "context":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "context", root: expression["@_id"] }], false),
                    cell: expression,
                });
            (_a = expression.contextEntry) === null || _a === void 0 ? void 0 : _a.forEach(function (ce, row) {
                var _a, _b;
                var id = (_b = (_a = ce.variable) === null || _a === void 0 ? void 0 : _a["@_id"]) !== null && _b !== void 0 ? _b : ce === null || ce === void 0 ? void 0 : ce["@_id"];
                id &&
                    ce.variable &&
                    map.set(id, {
                        expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                            { type: "context", row: row, column: "variable", root: expression["@_id"] },
                        ], false),
                        cell: ce.variable,
                    });
                generateBoxedExpressionIndex(ce.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                    { type: "context", row: row, column: "expression", root: expression["@_id"] },
                ], false));
            });
            return map;
        case "decisionTable":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "decisionTable", root: expression["@_id"] }], false),
                    cell: expression,
                });
            expression.output.forEach(function (o, column) {
                return o["@_id"] &&
                    map.set(o["@_id"], {
                        expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                            { type: "decisionTable", header: "output", row: -1, column: column, root: expression["@_id"] },
                        ], false),
                        cell: o,
                    });
            });
            (_b = expression.input) === null || _b === void 0 ? void 0 : _b.forEach(function (i, column) {
                i["@_id"] &&
                    map.set(i["@_id"], {
                        expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                            { type: "decisionTable", header: "input", row: -1, column: column, root: expression["@_id"] },
                        ], false),
                        cell: i,
                    });
            });
            (_c = expression.rule) === null || _c === void 0 ? void 0 : _c.forEach(function (r, row) {
                var _a, _b;
                (_a = r.outputEntry) === null || _a === void 0 ? void 0 : _a.forEach(function (ro, column) {
                    return ro["@_id"] &&
                        map.set(ro["@_id"], {
                            expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                                { type: "decisionTable", header: "output", row: row, column: column, root: expression["@_id"] },
                            ], false),
                            cell: ro,
                        });
                });
                (_b = r.inputEntry) === null || _b === void 0 ? void 0 : _b.forEach(function (ri, column) {
                    return ri["@_id"] &&
                        map.set(ri["@_id"], {
                            expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                                { type: "decisionTable", header: "input", row: row, column: column, root: expression["@_id"] },
                            ], false),
                            cell: ri,
                        });
                });
            });
            return map;
        case "every":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "every", root: expression["@_id"] }], false),
                    cell: expression,
                });
            expression["@_id"] &&
                map.set("".concat(expression["@_id"], "-iteratorVariable"), {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "every", row: "variable", root: expression["@_id"] }], false),
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.in.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "every", row: "in", root: expression["@_id"] },
            ], false));
            generateBoxedExpressionIndex(expression.satisfies.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "every", row: "statisfies", root: expression["@_id"] },
            ], false));
            return map;
        case "filter":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "filter", root: expression["@_id"] }], false),
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.in.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "filter", row: "in", root: expression["@_id"] },
            ], false));
            generateBoxedExpressionIndex(expression.match.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "filter", row: "match", root: expression["@_id"] },
            ], false));
            return map;
        case "for":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "for", root: expression["@_id"] }], false),
                    cell: expression,
                });
            expression["@_id"] &&
                map.set("".concat(expression["@_id"], "-iteratorVariable"), {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "for", row: "variable", root: expression["@_id"] }], false),
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.in.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "for", row: "in", root: expression["@_id"] },
            ], false));
            generateBoxedExpressionIndex(expression.return.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "for", row: "return", root: expression["@_id"] },
            ], false));
            return map;
        case "functionDefinition":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "functionDefinition", root: expression["@_id"] }], false),
                    cell: expression,
                });
            if ((_d = expression.expression) === null || _d === void 0 ? void 0 : _d["@_id"]) {
                generateBoxedExpressionIndex(expression.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                    { type: "functionDefinition", parameterIndex: -1, root: expression["@_id"] },
                ], false));
            }
            map.set("".concat(expression["@_id"], "-parameters"), {
                expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                    { type: "functionDefinition", parameterIndex: 0, root: expression["@_id"] },
                ], false),
                cell: (_e = expression.formalParameter) !== null && _e !== void 0 ? _e : [],
            });
            return map;
        case "invocation":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "invocation", root: expression["@_id"] }], false),
                    cell: expression,
                });
            (_f = expression.binding) === null || _f === void 0 ? void 0 : _f.forEach(function (b, row) {
                b.parameter["@_id"] &&
                    map.set(b.parameter["@_id"], {
                        expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                            { type: "invocation", row: row, column: "parameter", root: expression["@_id"] },
                        ], false),
                        cell: b.parameter,
                    });
                b.expression &&
                    generateBoxedExpressionIndex(b.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                        { type: "invocation", row: row, column: "expression", root: expression["@_id"] },
                    ], false));
            });
            expression.expression &&
                expression.expression["@_id"] &&
                map.set(expression.expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                        { type: "invocation", row: -1, column: "expression", root: expression["@_id"] },
                    ], false),
                    cell: expression.expression,
                });
            return map;
        case "list":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "list", root: expression["@_id"] }], false),
                    cell: expression,
                });
            (_g = expression.expression) === null || _g === void 0 ? void 0 : _g.forEach(function (e, row) {
                return generateBoxedExpressionIndex(e, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                    { type: "list", row: row, root: expression["@_id"] },
                ], false));
            });
            return map;
        case "literalExpression":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "literalExpression", root: expression["@_id"] }], false),
                    cell: expression,
                });
            return map;
        case "relation":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "relation", root: expression["@_id"] }], false),
                    cell: expression,
                });
            (_h = expression.column) === null || _h === void 0 ? void 0 : _h.forEach(function (c, column) {
                return c["@_id"] &&
                    map.set(c["@_id"], {
                        expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "relation", row: -1, column: column, root: expression["@_id"] }], false),
                        cell: c,
                    });
            });
            (_j = expression.row) === null || _j === void 0 ? void 0 : _j.forEach(function (r, row) {
                var _a;
                return (_a = r.expression) === null || _a === void 0 ? void 0 : _a.forEach(function (re, column) {
                    re["@_id"] &&
                        map.set(re["@_id"], {
                            expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "relation", row: row, column: column, root: expression["@_id"] }], false),
                            cell: re,
                        });
                });
            });
            return map;
        case "some":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "some", root: expression["@_id"] }], false),
                    cell: expression,
                });
            expression["@_id"] &&
                map.set("".concat(expression["@_id"], "-iteratorVariable"), {
                    expressionPath: __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [{ type: "some", row: "variable", root: expression["@_id"] }], false),
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.in.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "some", row: "in", root: expression["@_id"] },
            ], false));
            generateBoxedExpressionIndex(expression.satisfies.expression, map, __spreadArray(__spreadArray([], __read(parentExpressionPath), false), [
                { type: "some", row: "statisfies", root: expression["@_id"] },
            ], false));
            return map;
    }
}
export function getDmnObjectByPath(paths, expressionRoot) {
    if (!expressionRoot) {
        return;
    }
    return paths.reduce(function (expressionToEdit, path) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        if (path.type === "conditional") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "if") {
                return expressionToEdit.if.expression;
            }
            if (path.row === "else") {
                return expressionToEdit.else.expression;
            }
            return expressionToEdit.then.expression;
        }
        if (path.type === "context") {
            if (path.row === undefined || path.column === undefined) {
                return expressionToEdit;
            }
            if (path.column === "expression") {
                return (_a = expressionToEdit.contextEntry) === null || _a === void 0 ? void 0 : _a[path.row].expression;
            }
            return (_b = expressionToEdit.contextEntry) === null || _b === void 0 ? void 0 : _b[path.row].variable;
        }
        if (path.type === "decisionTable") {
            if (path.row === undefined || path.column === undefined) {
                return expressionToEdit;
            }
            if (path.header === "input") {
                if (path.row < 0) {
                    return (_c = expressionToEdit.input) === null || _c === void 0 ? void 0 : _c[path.column];
                }
                return (_e = (_d = expressionToEdit.rule) === null || _d === void 0 ? void 0 : _d[path.row].inputEntry) === null || _e === void 0 ? void 0 : _e[path.column];
            }
            if (path.row < 0) {
                return (_f = expressionToEdit.output) === null || _f === void 0 ? void 0 : _f[path.column];
            }
            return (_h = (_g = expressionToEdit.rule) === null || _g === void 0 ? void 0 : _g[path.row].outputEntry) === null || _h === void 0 ? void 0 : _h[path.column];
        }
        if (path.type === "every") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "variable") {
                return expressionToEdit;
            }
            if (path.row === "in") {
                return expressionToEdit.in.expression;
            }
            return expressionToEdit.satisfies.expression;
        }
        if (path.type === "filter") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "in") {
                return expressionToEdit.in.expression;
            }
            return expressionToEdit.match.expression;
        }
        if (path.type === "for") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "variable") {
                return expressionToEdit;
            }
            if (path.row === "in") {
                return expressionToEdit.in.expression;
            }
            return expressionToEdit.return.expression;
        }
        if (path.type === "functionDefinition") {
            if (!path.parameterIndex) {
                return expressionToEdit;
            }
            if (path.parameterIndex < 0) {
                return expressionToEdit.expression;
            }
            return expressionToEdit;
        }
        if (path.type === "invocation") {
            if (path.row === undefined || path.column === undefined) {
                return expressionToEdit;
            }
            if (path.column === "parameter") {
                return (_j = expressionToEdit.binding) === null || _j === void 0 ? void 0 : _j[path.row].parameter;
            }
            if (path.column === "expression" && path.row >= 0) {
                return (_k = expressionToEdit.binding) === null || _k === void 0 ? void 0 : _k[path.row].expression;
            }
            return expressionToEdit.expression;
        }
        if (path.type === "list") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            return (_l = expressionToEdit.expression) === null || _l === void 0 ? void 0 : _l[path.row];
        }
        if (path.type === "literalExpression") {
            return expressionToEdit;
        }
        if (path.type === "relation") {
            if (path.row === undefined || path.column === undefined) {
                return expressionToEdit;
            }
            if (path.row < 0) {
                return (_m = expressionToEdit.column) === null || _m === void 0 ? void 0 : _m[path.column];
            }
            return (_p = (_o = expressionToEdit.row) === null || _o === void 0 ? void 0 : _o[path.row].expression) === null || _p === void 0 ? void 0 : _p[path.column];
        }
        if (path.type === "some") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "variable") {
                return expressionToEdit;
            }
            if (path.row === "in") {
                return expressionToEdit.in.expression;
            }
            return expressionToEdit.satisfies.expression;
        }
    }, expressionRoot);
}
//# sourceMappingURL=boxedExpressionIndex.js.map