var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import { CopyIcon } from "@patternfly/react-icons/dist/js/icons/copy-icon";
import { CutIcon } from "@patternfly/react-icons/dist/js/icons/cut-icon";
import { PasteIcon } from "@patternfly/react-icons/dist/js/icons/paste-icon";
import { PlusCircleIcon } from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import * as React from "react";
import { useCallback, useMemo } from "react";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { TypeRefSelector } from "./TypeRefSelector";
import { Dropdown, DropdownItem, DropdownSeparator, KebabToggle, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { ImportIcon } from "@patternfly/react-icons/dist/js/icons/import-icon";
import { AngleDownIcon } from "@patternfly/react-icons/dist/js/icons/angle-down-icon";
import { AngleRightIcon } from "@patternfly/react-icons/dist/js/icons/angle-right-icon";
import { EyeIcon } from "@patternfly/react-icons/dist/js/icons/eye-icon";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { DataTypeName } from "./DataTypeName";
import { canHaveConstraints, getNewItemDefinition, isStruct } from "./DataTypeSpec";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { buildClipboardFromDataType, DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE, getClipboard, } from "../clipboard/Clipboard";
import { getNewDmnIdRandomizer } from "../idRandomizer/dmnIdRandomizer";
import { isEnum } from "./ConstraintsEnum";
import { isRange } from "./ConstraintsRange";
import { constraintTypeHelper, recursivelyGetRootItemDefinition } from "./Constraints";
import { builtInFeelTypeNames } from "./BuiltInFeelTypes";
import { useDmnEditor } from "../DmnEditorContext";
import { resolveTypeRef } from "./resolveTypeRef";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export var BRIGHTNESS_DECREASE_STEP_IN_PERCENTAGE_PER_NESTING_LEVEL = 5;
export var STARTING_BRIGHTNESS_LEVEL_IN_PERCENTAGE = 95;
var addItemComponentButtonWidthInPxs = 24;
var expandButtonWidthInPxs = 24;
var expandButtonoHorizontalMarginInPxs = 12;
var leftGutterForStructsInPxs = addItemComponentButtonWidthInPxs + expandButtonWidthInPxs + expandButtonoHorizontalMarginInPxs * 2;
var rowPaddingRight = 16;
export function ItemComponentsTable(_a) {
    var isReadonly = _a.isReadonly, parent = _a.parent, editItemDefinition = _a.editItemDefinition, addItemComponent = _a.addItemComponent, dropdownOpenFor = _a.dropdownOpenFor, allDataTypesById = _a.allDataTypesById, setDropdownOpenFor = _a.setDropdownOpenFor;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var expandedItemComponentIds = useDmnEditorStore(function (s) { return s.dataTypesEditor.expandedItemComponentIds; });
    var allTopLevelDataTypesByFeelName = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName; });
    var allTopLevelItemDefinitionUniqueNames = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames; });
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var expandedItemComponentIdsSet = useMemo(function () {
        return new Set(expandedItemComponentIds);
    }, [expandedItemComponentIds]);
    var dataTypes = parent.children;
    var flatTree = useMemo(function () {
        var _a;
        var ret = [];
        function traverse(dataType, allUniqueNamesAtLevel) {
            var _a, _b, _c;
            for (var i = 0; i < ((_a = dataType === null || dataType === void 0 ? void 0 : dataType.length) !== null && _a !== void 0 ? _a : 0); i++) {
                ret.push({ dataType: dataType[i], allUniqueNamesAtLevel: allUniqueNamesAtLevel });
                traverse((_b = dataType[i].children) !== null && _b !== void 0 ? _b : [], ((_c = dataType[i].itemDefinition.itemComponent) !== null && _c !== void 0 ? _c : []).reduce(function (acc, s) { return acc.set(s["@_name"], s["@_id"]); }, new Map(__spreadArray([], __read(builtInFeelTypeNames), false).map(function (s) { return [s, s]; }))));
            }
        }
        traverse(dataTypes !== null && dataTypes !== void 0 ? dataTypes : [], ((_a = parent.itemDefinition.itemComponent) !== null && _a !== void 0 ? _a : []).reduce(function (acc, s) { return acc.set(s["@_name"], s["@_id"]); }, new Map(__spreadArray([], __read(builtInFeelTypeNames), false).map(function (s) { return [s, s]; }))));
        return ret;
    }, [dataTypes, parent.itemDefinition.itemComponent]);
    var expandAll = useCallback(function () {
        dmnEditorStoreApi.setState(function (state) {
            state.dataTypesEditor.expandedItemComponentIds = flatTree.flatMap(function (s) {
                return isStruct(s.dataType.itemDefinition) ? s.dataType.itemDefinition["@_id"] : [];
            });
        });
    }, [dmnEditorStoreApi, flatTree]);
    var collapseAll = useCallback(function () {
        dmnEditorStoreApi.setState(function (state) {
            state.dataTypesEditor.expandedItemComponentIds = [];
        });
    }, [dmnEditorStoreApi]);
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    return (_jsxs(_Fragment, { children: [_jsxs(Flex, __assign({ justifyContent: { default: "justifyContentSpaceBetween" } }, { children: [_jsx(FlexItem, { children: _jsxs(Title, __assign({ size: "md", headingLevel: "h4" }, { children: ["Properties in '".concat(parent.itemDefinition["@_name"], "'"), !isReadonly && (_jsx(Button, __assign({ title: "Add item component (at the top)", variant: ButtonVariant.link, onClick: function () {
                                        return addItemComponent(parent.itemDefinition["@_id"], "unshift", {
                                            "@_name": "New property",
                                            typeRef: undefined,
                                        });
                                    } }, { children: _jsx(PlusCircleIcon, {}) })))] })) }), _jsxs(FlexItem, { children: [_jsx(Button, __assign({ variant: ButtonVariant.link, onClick: expandAll }, { children: "Expand all" })), _jsx(Button, __assign({ variant: ButtonVariant.link, onClick: collapseAll }, { children: "Collapse all" })), !isReadonly && (_jsx(Dropdown, { toggle: _jsx(KebabToggle, { id: "toggle-kebab-properties-table", onToggle: function (isOpen) { return setDropdownOpenFor(isOpen ? parent.itemDefinition["@_id"] : undefined); } }), onSelect: function () { return setDropdownOpenFor(undefined); }, isOpen: dropdownOpenFor === parent.itemDefinition["@_id"], menuAppendTo: document.body, isPlain: true, position: "right", dropdownItems: [
                                    _jsx(DropdownItem, __assign({ style: { minWidth: "240px" }, icon: _jsx(PasteIcon, {}), onClick: function () {
                                            navigator.clipboard.readText().then(function (text) {
                                                var e_1, _a;
                                                var clipboard = getClipboard(text, DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE);
                                                if (!clipboard) {
                                                    return;
                                                }
                                                getNewDmnIdRandomizer()
                                                    .ack({
                                                    json: clipboard.itemDefinitions,
                                                    type: "DMN15__tDefinitions",
                                                    attr: "itemDefinition",
                                                })
                                                    .randomize();
                                                try {
                                                    for (var _b = __values(clipboard.itemDefinitions), _c = _b.next(); !_c.done; _c = _b.next()) {
                                                        var itemDefinition = _c.value;
                                                        addItemComponent(parent.itemDefinition["@_id"], "unshift", itemDefinition);
                                                    }
                                                }
                                                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                                                finally {
                                                    try {
                                                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                                                    }
                                                    finally { if (e_1) throw e_1.error; }
                                                }
                                            });
                                        } }, { children: "Paste property" }), "paste-property"),
                                ] }))] })] })), flatTree.length <= 0 && (_jsx("div", __assign({ className: "kie-dmn-editor--data-type-properties-table--empty-state" }, { children: isReadonly ? "None" : "None yet" }))), flatTree.length > 0 && (_jsxs("table", __assign({ className: "kie-dmn-editor--data-type-properties-table" }, { children: [_jsx("thead", { children: _jsxs("tr", { children: [_jsx("th", __assign({ style: { minWidth: "200px", width: "67%" } }, { children: "Name" })), _jsx("th", __assign({ style: { minWidth: "140px", maxWidth: "140px" } }, { children: "Is struct?" })), _jsx("th", __assign({ style: { minWidth: "280px", width: "33%" } }, { children: "Type" })), _jsx("th", __assign({ style: { minWidth: "140px", maxWidth: "140px" } }, { children: "Is collection?" })), _jsx("th", __assign({ style: { minWidth: "200px", maxWidth: "200px" } }, { children: "Constraints" })), _jsx("th", {})] }) }), _jsx("tbody", { children: flatTree.map(function (_a, i) {
                            var e_2, _b;
                            var _c, _d, _e, _f;
                            var dt = _a.dataType, allUniqueNamesAtLevel = _a.allUniqueNamesAtLevel;
                            var nextDt = flatTree[Math.min(i + 1, flatTree.length - 1)].dataType;
                            var lastDt = flatTree[Math.max(i - 1, 0)].dataType;
                            var nextIsUpper = nextDt.parents.size < dt.parents.size;
                            var lastIsUpper = lastDt.parents.size < dt.parents.size;
                            var areAllParentsExpanded = true;
                            try {
                                for (var _g = __values(__spreadArray([], __read(dt.parents), false).reverse()), _h = _g.next(); !_h.done; _h = _g.next()) {
                                    var p = _h.value;
                                    if (p === parent.itemDefinition["@_id"]) {
                                        break;
                                    }
                                    else if (!expandedItemComponentIdsSet.has(p)) {
                                        areAllParentsExpanded = false;
                                    }
                                }
                            }
                            catch (e_2_1) { e_2 = { error: e_2_1 }; }
                            finally {
                                try {
                                    if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
                                }
                                finally { if (e_2) throw e_2.error; }
                            }
                            var shouldShowRow = dt.parentId === parent.itemDefinition["@_id"] ||
                                (isStruct(allDataTypesById.get(dt.parentId).itemDefinition) && areAllParentsExpanded);
                            var level = dt.parents.size - parent.parents.size - 1;
                            var brigthnessPercentage = STARTING_BRIGHTNESS_LEVEL_IN_PERCENTAGE -
                                level * BRIGHTNESS_DECREASE_STEP_IN_PERCENTAGE_PER_NESTING_LEVEL;
                            var constraintLabel = function () {
                                var _a, _b, _c, _d, _e, _f, _g, _h, _j;
                                if (((_a = dt.itemDefinition.typeConstraint) === null || _a === void 0 ? void 0 : _a["@_kie:constraintType"]) === "enumeration" ||
                                    ((_b = dt.itemDefinition.allowedValues) === null || _b === void 0 ? void 0 : _b["@_kie:constraintType"]) === "enumeration") {
                                    return _jsx(_Fragment, { children: "Enumeration" });
                                }
                                if (((_c = dt.itemDefinition.typeConstraint) === null || _c === void 0 ? void 0 : _c["@_kie:constraintType"]) === "expression" ||
                                    ((_d = dt.itemDefinition.allowedValues) === null || _d === void 0 ? void 0 : _d["@_kie:constraintType"]) === "expression") {
                                    return _jsx(_Fragment, { children: "Expression" });
                                }
                                if (((_e = dt.itemDefinition.typeConstraint) === null || _e === void 0 ? void 0 : _e["@_kie:constraintType"]) === "range" ||
                                    ((_f = dt.itemDefinition.allowedValues) === null || _f === void 0 ? void 0 : _f["@_kie:constraintType"]) === "range") {
                                    return _jsx(_Fragment, { children: "Range" });
                                }
                                var constraintValue = (_h = (_g = dt.itemDefinition.typeConstraint) === null || _g === void 0 ? void 0 : _g.text.__$$text) !== null && _h !== void 0 ? _h : (_j = dt.itemDefinition.allowedValues) === null || _j === void 0 ? void 0 : _j.text.__$$text;
                                var typeHelper = constraintTypeHelper(dt.itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames);
                                if (constraintValue === undefined) {
                                    return _jsx(_Fragment, { children: "None" });
                                }
                                if (isEnum(constraintValue, typeHelper.check)) {
                                    return _jsx(_Fragment, { children: "Enumeration" });
                                }
                                if (isRange(constraintValue, typeHelper.check)) {
                                    return _jsx(_Fragment, { children: "Range" });
                                }
                                return _jsx(_Fragment, { children: "Expression" });
                            };
                            var rootItemDefinition = recursivelyGetRootItemDefinition(dt.itemDefinition, allDataTypesById, allTopLevelItemDefinitionUniqueNames);
                            var isItemComponent = !!((_d = (_c = parent.itemDefinition) === null || _c === void 0 ? void 0 : _c.itemComponent) === null || _d === void 0 ? void 0 : _d.find(function (ic) { return ic["@_id"] === rootItemDefinition["@_id"]; }));
                            return (_jsx(React.Fragment, { children: shouldShowRow && (_jsxs("tr", __assign({ style: { backdropFilter: "brightness(".concat(brigthnessPercentage, "%)") }, className: "".concat(nextIsUpper ? "last-nested-at-level" : "", " ").concat(lastIsUpper ? "first-nested-at-level" : "") }, { children: [_jsx("td", __assign({ style: {
                                                paddingLeft: "".concat(rowPaddingRight + level * leftGutterForStructsInPxs, "px"),
                                            } }, { children: _jsxs("div", __assign({ style: { display: "flex" } }, { children: [_jsx("div", __assign({ style: {
                                                            width: "".concat(expandButtonWidthInPxs, "px"),
                                                            margin: "0 ".concat(expandButtonoHorizontalMarginInPxs, "px"),
                                                        } }, { children: isStruct(dt.itemDefinition) && (_jsx(Button, __assign({ title: "Expand / collapse item component", variant: ButtonVariant.link, style: { padding: "0 8px 0 0" }, onClick: function (e) {
                                                                return dmnEditorStoreApi.setState(function (state) {
                                                                    if (expandedItemComponentIdsSet.has(dt.itemDefinition["@_id"])) {
                                                                        state.dataTypesEditor.expandedItemComponentIds =
                                                                            state.dataTypesEditor.expandedItemComponentIds.filter(function (s) { return s !== dt.itemDefinition["@_id"]; });
                                                                    }
                                                                    else {
                                                                        state.dataTypesEditor.expandedItemComponentIds.push(dt.itemDefinition["@_id"]);
                                                                    }
                                                                });
                                                            } }, { children: (expandedItemComponentIdsSet.has(dt.itemDefinition["@_id"]) && _jsx(AngleDownIcon, {})) || (_jsx(AngleRightIcon, {})) }))) })), _jsx("div", __assign({ style: { width: "".concat(addItemComponentButtonWidthInPxs, "px") } }, { children: !isReadonly && isStruct(dt.itemDefinition) && (_jsx(Button, __assign({ title: "Add item component", variant: ButtonVariant.link, style: { padding: "0 8px 0 0" }, onClick: function () {
                                                                addItemComponent(dt.itemDefinition["@_id"], "unshift", {
                                                                    "@_name": "New property",
                                                                    typeRef: undefined,
                                                                });
                                                                dmnEditorStoreApi.setState(function (state) {
                                                                    state.dataTypesEditor.expandedItemComponentIds.push(dt.itemDefinition["@_id"]);
                                                                });
                                                            } }, { children: _jsx(PlusCircleIcon, {}) }))) })), _jsx("div", __assign({ style: { flexGrow: 1 } }, { children: _jsx(DataTypeName, { relativeToNamespace: dt.namespace, editMode: "hover", isActive: false, itemDefinition: dt.itemDefinition, isReadonly: dt.namespace !== thisDmnsNamespace, onGetAllUniqueNames: function () { return allUniqueNamesAtLevel; } }) }))] })) })), _jsx("td", { children: _jsx(Switch, { "aria-label": "Is struct?", isChecked: isStruct(dt.itemDefinition), onChange: function (isChecked) {
                                                    editItemDefinition(dt.itemDefinition["@_id"], function (itemDefinition, items) {
                                                        if (isChecked) {
                                                            itemDefinition.typeRef = undefined;
                                                            itemDefinition.itemComponent = [];
                                                            itemDefinition.typeConstraint = undefined;
                                                            itemDefinition.allowedValues = undefined;
                                                        }
                                                        else {
                                                            itemDefinition.typeRef = { __$$text: DmnBuiltInDataType.Any };
                                                            itemDefinition.typeConstraint = undefined;
                                                            itemDefinition.allowedValues = undefined;
                                                        }
                                                    });
                                                } }) }), _jsx("td", { children: !isStruct(dt.itemDefinition) && (_jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, isDisabled: isReadonly, typeRef: resolveTypeRef({
                                                    typeRef: (_e = dt.itemDefinition.typeRef) === null || _e === void 0 ? void 0 : _e.__$$text,
                                                    namespace: parent.namespace,
                                                    allTopLevelDataTypesByFeelName: allTopLevelDataTypesByFeelName,
                                                    externalModelsByNamespace: externalModelsByNamespace,
                                                    thisDmnsImportsByNamespace: importsByNamespace,
                                                    relativeToNamespace: thisDmnsNamespace,
                                                }), onChange: function (newDataType) {
                                                    editItemDefinition(dt.itemDefinition["@_id"], function (itemDefinition, items) {
                                                        var _a;
                                                        if (((_a = itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) !== newDataType) {
                                                            itemDefinition.typeConstraint = undefined;
                                                            itemDefinition.allowedValues = undefined;
                                                        }
                                                        itemDefinition.typeRef = newDataType ? { __$$text: newDataType } : undefined;
                                                    });
                                                } })) }), _jsx("td", { children: _jsx(Switch, { "aria-label": "Is collection?", isChecked: (_f = dt.itemDefinition["@_isCollection"]) !== null && _f !== void 0 ? _f : false, onChange: function (isChecked) {
                                                    editItemDefinition(dt.itemDefinition["@_id"], function (itemDefinition, items) {
                                                        itemDefinition["@_isCollection"] = isChecked;
                                                        itemDefinition.typeConstraint = undefined;
                                                        itemDefinition.allowedValues = undefined;
                                                    });
                                                } }) }), _jsx("td", { children: canHaveConstraints(rootItemDefinition) ||
                                                (isStruct(rootItemDefinition) && !isItemComponent) ? (_jsx(Button, __assign({ variant: ButtonVariant.link, onClick: function () {
                                                    dmnEditorStoreApi.setState(function (state) {
                                                        state.dataTypesEditor.activeItemDefinitionId = dt.itemDefinition["@_id"];
                                                    });
                                                } }, { children: constraintLabel() }))) : (_jsx("p", __assign({ style: { paddingLeft: "16px", paddingRight: "16px" } }, { children: "-" }))) }), _jsx("td", { children: _jsx(Dropdown, { toggle: _jsx(KebabToggle, { id: "toggle-kebab-" + dt.itemDefinition["@_id"], onToggle: function (isOpen) { return setDropdownOpenFor(isOpen ? dt.itemDefinition["@_id"] : undefined); } }), onSelect: function () { return setDropdownOpenFor(undefined); }, isOpen: dropdownOpenFor === dt.itemDefinition["@_id"], menuAppendTo: document.body, isPlain: true, position: "right", dropdownItems: [
                                                    _jsx(DropdownItem, __assign({ icon: _jsx(EyeIcon, {}), onClick: function () {
                                                            dmnEditorStoreApi.setState(function (state) {
                                                                state.dataTypesEditor.activeItemDefinitionId = dt.itemDefinition["@_id"];
                                                            });
                                                        } }, { children: "View" }), "view-type"),
                                                    _jsx(DropdownSeparator, {}, "view-separator"),
                                                    _jsx(DropdownItem, __assign({ icon: _jsx(ImportIcon, { style: { transform: "scale(-1, -1)" } }), style: { minWidth: "240px" }, onClick: function () {
                                                            editItemDefinition(dt.itemDefinition["@_id"], function (itemDefinition, _, __, itemDefinitions) {
                                                                var newItemDefinition = getNewItemDefinition(__assign(__assign({}, dt.itemDefinition), { typeRef: dt.itemDefinition.typeRef, "@_name": "t".concat(dt.itemDefinition["@_name"]), "@_isCollection": false }));
                                                                var newItemDefinitionCopy = JSON.parse(JSON.stringify(newItemDefinition));
                                                                getNewDmnIdRandomizer()
                                                                    .ack({
                                                                    json: [newItemDefinitionCopy],
                                                                    type: "DMN15__tDefinitions",
                                                                    attr: "itemDefinition",
                                                                })
                                                                    .randomize();
                                                                itemDefinitions.unshift(newItemDefinitionCopy);
                                                                if (!isReadonly) {
                                                                    itemDefinition["@_id"] = generateUuid();
                                                                    itemDefinition.typeRef = { __$$text: newItemDefinitionCopy["@_name"] };
                                                                    itemDefinition.itemComponent = undefined;
                                                                }
                                                            });
                                                        } }, { children: "Extract data type" }), "extract-to-top-level"),
                                                    _jsx(DropdownSeparator, {}, "extract-data-type-separator"),
                                                    _jsx(DropdownItem, __assign({ icon: _jsx(CopyIcon, {}), onClick: function () {
                                                            var clipboard = buildClipboardFromDataType(dt, thisDmnsNamespace);
                                                            navigator.clipboard.writeText(JSON.stringify(clipboard));
                                                        } }, { children: "Copy" }), "copy-item"),
                                                    _jsx(React.Fragment, { children: !isReadonly && (_jsx(DropdownItem, __assign({ icon: _jsx(CutIcon, {}), onClick: function () {
                                                                var clipboard = buildClipboardFromDataType(dt, thisDmnsNamespace);
                                                                navigator.clipboard.writeText(JSON.stringify(clipboard)).then(function () {
                                                                    editItemDefinition(dt.parentId, function (itemDefinition) {
                                                                        var _a;
                                                                        (_a = itemDefinition.itemComponent) === null || _a === void 0 ? void 0 : _a.splice(dt.index, 1);
                                                                    });
                                                                });
                                                            } }, { children: "Cut" }), "cut-item")) }, "cut-fragment"),
                                                    _jsx(React.Fragment, { children: !isReadonly && (_jsx(DropdownItem, __assign({ icon: _jsx(TrashIcon, {}), onClick: function () {
                                                                editItemDefinition(dt.parentId, function (itemDefinition) {
                                                                    var _a;
                                                                    (_a = itemDefinition.itemComponent) === null || _a === void 0 ? void 0 : _a.splice(dt.index, 1);
                                                                });
                                                            } }, { children: "Remove" }), "remove-item")) }, "remove-fragment"),
                                                    !isReadonly && isStruct(dt.itemDefinition) ? (_jsxs(React.Fragment, { children: [_jsx(DropdownSeparator, {}), _jsx(React.Fragment, { children: _jsx(DropdownItem, __assign({ icon: _jsx(PasteIcon, {}), onClick: function () {
                                                                        navigator.clipboard.readText().then(function (text) {
                                                                            var e_3, _a;
                                                                            var clipboard = getClipboard(text, DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE);
                                                                            if (!clipboard) {
                                                                                return;
                                                                            }
                                                                            getNewDmnIdRandomizer()
                                                                                .ack({
                                                                                json: clipboard.itemDefinitions,
                                                                                type: "DMN15__tDefinitions",
                                                                                attr: "itemDefinition",
                                                                            })
                                                                                .randomize();
                                                                            try {
                                                                                for (var _b = __values(clipboard.itemDefinitions), _c = _b.next(); !_c.done; _c = _b.next()) {
                                                                                    var itemDefinition = _c.value;
                                                                                    addItemComponent(dt.itemDefinition["@_id"], "unshift", itemDefinition);
                                                                                }
                                                                            }
                                                                            catch (e_3_1) { e_3 = { error: e_3_1 }; }
                                                                            finally {
                                                                                try {
                                                                                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                                                                                }
                                                                                finally { if (e_3) throw e_3.error; }
                                                                            }
                                                                        });
                                                                    } }, { children: "Paste property" })) })] }, "paste-property-fragment")) : (_jsx(React.Fragment, {}, "paste-property-empty-fragment")),
                                                ] }) })] }))) }, dt.itemDefinition["@_id"]));
                        }) }), !isReadonly && (_jsx("tfoot", { children: _jsx("tr", { children: _jsx("td", __assign({ colSpan: 5 }, { children: _jsxs(Button, __assign({ variant: ButtonVariant.link, onClick: function () {
                                        return addItemComponent(parent.itemDefinition["@_id"], "push", {
                                            "@_name": "New property",
                                            typeRef: undefined,
                                        });
                                    }, style: { paddingLeft: 0 } }, { children: [_jsx(PlusCircleIcon, {}), "\u00A0\u00A0", "Add property to '".concat(parent.itemDefinition["@_name"], "'")] })) })) }) }))] })))] }));
}
//# sourceMappingURL=ItemComponentsTable.js.map