var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { Fragment as _Fragment, jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import { DmnBuiltInDataType, generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { buildFeelQNameFromXmlQName } from "../feel/buildFeelQName";
import { buildXmlQName, parseXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { useDmnEditorStore } from "../store/StoreContext";
import { getXmlNamespaceDeclarationName } from "../xml/xmlNamespaceDeclarations";
import { parseFeelQName } from "../feel/parseFeelQName";
import { builtInFeelTypeNames } from "./BuiltInFeelTypes";
export function TypeRefLabel(_a) {
    var typeRef = _a.typeRef, relativeToNamespace = _a.relativeToNamespace, isCollection = _a.isCollection;
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var thisDmn = useDmnEditorStore(function (s) { return s.dmn; });
    var feelName = useMemo(function () {
        if (!typeRef) {
            return undefined;
        }
        if (builtInFeelTypeNames.has(typeRef)) {
            return typeRef;
        }
        var parsedFeelQName = parseFeelQName(typeRef);
        var xmlNamespaceName = getXmlNamespaceDeclarationName({
            rootElement: thisDmn.model.definitions,
            namespace: relativeToNamespace !== null && relativeToNamespace !== void 0 ? relativeToNamespace : "",
        });
        var xmlQName = parseXmlQName(buildXmlQName({
            type: "xml-qname",
            prefix: xmlNamespaceName,
            localPart: parsedFeelQName.importName ? parsedFeelQName.localPart : typeRef,
        }));
        if (xmlQName.prefix) {
            return typeRef;
        }
        var fullFeelQName = buildFeelQNameFromXmlQName({
            importsByNamespace: importsByNamespace,
            relativeToNamespace: thisDmn.model.definitions["@_namespace"],
            model: thisDmn.model.definitions,
            namedElement: {
                "@_id": generateUuid(),
                "@_name": parsedFeelQName.importName ? parsedFeelQName.localPart : typeRef,
            },
            namedElementQName: xmlQName,
        }).full;
        if (parsedFeelQName.importName) {
            if (typeRef !== fullFeelQName) {
                console.warn("DMN EDITOR: Data Type label was rendered with discrepancy between provided namespace and the FEEL QName. Going with the provided typeRef. (typeRef: '".concat(typeRef, "', feelQName: '").concat(fullFeelQName, "')."));
            }
            return typeRef;
        }
        return fullFeelQName;
    }, [thisDmn.model.definitions, importsByNamespace, relativeToNamespace, typeRef]);
    return (_jsx("span", __assign({ className: "kie-dmn-editor--data-type-label" }, { children: _jsx("i", { children: (typeRef && (_jsxs(_Fragment, { children: ["".concat(feelName !== null && feelName !== void 0 ? feelName : DmnBuiltInDataType.Undefined), isCollection && (_jsxs(_Fragment, { children: ["\u00A0", "[]"] }))] }))) || _jsx(_Fragment, { children: isCollection && _jsx(_Fragment, { children: "[]" }) }) }) })));
}
//# sourceMappingURL=TypeRefLabel.js.map