import { buildXmlHref } from "../xml/xmlHrefs";
import * as __path from "path";
export var KIE_PMML_NAMESPACE = "https://kie.org/pmml";
export var allPmmlImportNamespaces = new Set([
    "https://www.dmg.org/PMML-4_4",
    "http://www.dmg.org/PMML-4_4",
    "https://www.dmg.org/PMML-4_3",
    "http://www.dmg.org/PMML-4_3",
    "https://www.dmg.org/PMML-4_2",
    "http://www.dmg.org/PMML-4_2",
    "https://www.dmg.org/PMML-4_1",
    "http://www.dmg.org/PMML-4_1",
    "https://www.dmg.org/PMML-4_0",
    "http://www.dmg.org/PMML-4_0",
    "https://www.dmg.org/PMML-3_2",
    "http://www.dmg.org/PMML-3_2",
    "https://www.dmg.org/PMML-3_1",
    "http://www.dmg.org/PMML-3_1",
    "https://www.dmg.org/PMML-3_0",
    "http://www.dmg.org/PMML-3_0",
    "https://www.dmg.org/PMML-2_1",
    "http://www.dmg.org/PMML-2_1",
    "https://www.dmg.org/PMML-2_0",
    "http://www.dmg.org/PMML-2_0",
    "https://www.dmg.org/PMML-1_1",
    "http://www.dmg.org/PMML-1_1",
]);
export function getPmmlNamespace(_a) {
    var normalizedPosixPathRelativeToTheOpenFile = _a.normalizedPosixPathRelativeToTheOpenFile;
    return buildXmlHref({ namespace: KIE_PMML_NAMESPACE, id: normalizedPosixPathRelativeToTheOpenFile });
}
export function getPmmlNamespaceFromDmnImport(_a) {
    var dmnImport = _a.dmnImport;
    return dmnImport["@_locationURI"]
        ? getPmmlNamespace({
            normalizedPosixPathRelativeToTheOpenFile: __path.normalize(dmnImport["@_locationURI"]),
        })
        : dmnImport["@_namespace"];
}
//# sourceMappingURL=pmml.js.map