var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { KIE_DMN_UNKNOWN_NAMESPACE } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { snapShapeDimensions, snapShapePosition } from "../../diagram/SnapGrid";
import { EDGE_TYPES } from "../../diagram/edges/EdgeTypes";
import { getAdjMatrix, traverse } from "../../diagram/graph/graph";
import { getNodeTypeFromDmnObject } from "../../diagram/maths/DmnMaths";
import { DECISION_SERVICE_COLLAPSED_DIMENSIONS, MIN_NODE_SIZES } from "../../diagram/nodes/DefaultSizes";
import { ___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches } from "../../diagram/nodes/NodeSvgs";
import { NODE_TYPES } from "../../diagram/nodes/NodeTypes";
import { buildXmlHref, parseXmlHref } from "../../xml/xmlHrefs";
import { getDecisionServicePropertiesRelativeToThisDmn } from "../../mutations/addExistingDecisionServiceToDrd";
import { KIE_UNKNOWN_NAMESPACE } from "../../kie/kie";
export var NODE_LAYERS = {
    GROUP_NODE: 0,
    NODES: 1000,
    DECISION_SERVICE_NODE: 2000,
    NESTED_NODES: 4000,
};
export function computeDiagramData(diagram, definitions, externalModelTypesByNamespace, indexedDrd, isAlternativeInputDataShape) {
    var e_1, _a, e_2, _b;
    var _c, _d, _e, _f, _g;
    ___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches.flag =
        !___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches.flag;
    var drgElementsWithoutVisualRepresentationOnCurrentDrd = [];
    var selectedNodesById = new Map();
    var selectedEdgesById = new Map();
    var selectedNodeTypes = new Set();
    var nodesById = new Map();
    var edgesById = new Map();
    var parentIdsById = new Map();
    var externalNodesByNamespace = new Map();
    var edgesFromExternalNodesByNamespace = new Map();
    var _h = {
        selectedNodes: new Set(diagram._selectedNodes),
        draggingNodes: new Set(diagram.draggingNodes),
        resizingNodes: new Set(diagram.resizingNodes),
        selectedEdges: new Set(diagram._selectedEdges),
    }, selectedNodes = _h.selectedNodes, draggingNodes = _h.draggingNodes, resizingNodes = _h.resizingNodes, selectedEdges = _h.selectedEdges;
    var edges = [];
    var drgEdges = [];
    var drgAdjacencyList = new Map();
    var ackEdge = function (_a) {
        var _b;
        var id = _a.id, type = _a.type, dmnObject = _a.dmnObject, source = _a.source, target = _a.target, sourceNamespace = _a.sourceNamespace;
        var data = {
            dmnObject: dmnObject,
            dmnEdge: id ? indexedDrd.dmnEdgesByDmnElementRef.get(id) : undefined,
            dmnShapeSource: indexedDrd.dmnShapesByHref.get(source),
            dmnShapeTarget: indexedDrd.dmnShapesByHref.get(target),
        };
        var edge = {
            data: data,
            id: id,
            type: type,
            source: source,
            target: target,
            selected: selectedEdges.has(id),
        };
        if (sourceNamespace && sourceNamespace !== KIE_UNKNOWN_NAMESPACE) {
            edgesFromExternalNodesByNamespace.set(sourceNamespace, __spreadArray(__spreadArray([], __read(((_b = edgesFromExternalNodesByNamespace.get(sourceNamespace)) !== null && _b !== void 0 ? _b : [])), false), [
                edge,
            ], false));
        }
        edgesById.set(edge.id, edge);
        if (edge.selected) {
            selectedEdgesById.set(edge.id, edge);
        }
        edges.push(edge);
        drgEdges.push({ id: id, sourceId: source, targetId: target, dmnObject: dmnObject });
        var targetAdjancyList = drgAdjacencyList.get(target);
        if (!targetAdjancyList) {
            drgAdjacencyList.set(target, { dependencies: new Set([source]) });
        }
        else {
            targetAdjancyList.dependencies.add(source);
        }
        return edge;
    };
    ackRequirementEdges(definitions["@_namespace"], definitions["@_namespace"], definitions.drgElement, ackEdge);
    ((_c = definitions.artifact) !== null && _c !== void 0 ? _c : []).forEach(function (dmnObject, index) {
        var _a, _b;
        if (dmnObject.__$$element !== "association") {
            return;
        }
        ackEdge({
            id: dmnObject["@_id"],
            dmnObject: {
                namespace: definitions["@_namespace"],
                type: dmnObject.__$$element,
                id: dmnObject["@_id"],
                requirementType: "association",
                index: index,
            },
            type: EDGE_TYPES.association,
            source: (_a = dmnObject.sourceRef) === null || _a === void 0 ? void 0 : _a["@_href"],
            target: (_b = dmnObject.targetRef) === null || _b === void 0 ? void 0 : _b["@_href"],
            sourceNamespace: undefined,
        });
    });
    var ackNode = function (dmnObjectQName, dmnObject, index) {
        var _a, _b;
        var type = getNodeTypeFromDmnObject(dmnObject);
        if (!type) {
            return undefined;
        }
        var dmnObjectNamespace = dmnObjectQName.prefix
            ? (_a = definitions["@_xmlns:".concat(dmnObjectQName.prefix)]) !== null && _a !== void 0 ? _a : KIE_DMN_UNKNOWN_NAMESPACE
            : undefined;
        var id = buildXmlHref({ namespace: dmnObjectNamespace, id: dmnObjectQName.localPart });
        var _shape = indexedDrd.dmnShapesByHref.get(id);
        if (!_shape) {
            drgElementsWithoutVisualRepresentationOnCurrentDrd.push(id);
            return undefined;
        }
        var dmnElementRefQName = _shape.dmnElementRefQName, shape = __rest(_shape, ["dmnElementRefQName"]);
        var data = {
            dmnObjectNamespace: dmnObjectNamespace,
            dmnObjectQName: dmnObjectQName,
            dmnObject: dmnObject,
            shape: shape,
            index: index,
            hasHiddenRequirements: false,
            parentRfNode: undefined,
        };
        var newNode = {
            id: id,
            type: type,
            selected: selectedNodes.has(id),
            dragging: draggingNodes.has(id),
            resizing: resizingNodes.has(id),
            position: snapShapePosition(diagram.snapGrid, shape),
            data: data,
            zIndex: NODE_LAYERS.NODES,
            style: __assign({}, snapShapeDimensions(diagram.snapGrid, shape, MIN_NODE_SIZES[type]({ snapGrid: diagram.snapGrid, isAlternativeInputDataShape: isAlternativeInputDataShape }))),
        };
        if ((dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject.__$$element) === "decisionService") {
            var containedDecisionHrefsRelativeToThisDmn = getDecisionServicePropertiesRelativeToThisDmn({
                thisDmnsNamespace: definitions["@_namespace"],
                decisionServiceNamespace: dmnObjectNamespace !== null && dmnObjectNamespace !== void 0 ? dmnObjectNamespace : definitions["@_namespace"],
                decisionService: dmnObject,
            }).containedDecisionHrefsRelativeToThisDmn;
            for (var i = 0; i < containedDecisionHrefsRelativeToThisDmn.length; i++) {
                parentIdsById.set(containedDecisionHrefsRelativeToThisDmn[i], data);
            }
            if (shape["@_isCollapsed"]) {
                newNode.style = __assign(__assign({}, newNode.style), DECISION_SERVICE_COLLAPSED_DIMENSIONS);
            }
        }
        if (dmnObjectNamespace && dmnObjectNamespace !== KIE_UNKNOWN_NAMESPACE) {
            externalNodesByNamespace.set(dmnObjectNamespace, __spreadArray(__spreadArray([], __read(((_b = externalNodesByNamespace.get(dmnObjectNamespace)) !== null && _b !== void 0 ? _b : [])), false), [
                newNode,
            ], false));
        }
        nodesById.set(newNode.id, newNode);
        if (newNode.selected) {
            selectedNodesById.set(newNode.id, newNode);
            selectedNodeTypes.add(newNode.type);
        }
        return newNode;
    };
    var localNodes = __spreadArray(__spreadArray([], __read(((_d = definitions.drgElement) !== null && _d !== void 0 ? _d : []).flatMap(function (dmnObject, index) {
        var newNode = ackNode({ type: "xml-qname", localPart: dmnObject["@_id"] }, dmnObject, index);
        return newNode ? [newNode] : [];
    })), false), __read(((_e = definitions.artifact) !== null && _e !== void 0 ? _e : []).flatMap(function (dmnObject, index) {
        if (dmnObject.__$$element === "association") {
            return [];
        }
        var newNode = ackNode({ type: "xml-qname", localPart: dmnObject["@_id"] }, dmnObject, index);
        return newNode ? [newNode] : [];
    })), false);
    var externalDrgElementsByIdByNamespace = __spreadArray([], __read(externalModelTypesByNamespace.dmns.entries()), false).reduce(function (acc, _a) {
        var _b;
        var _c = __read(_a, 2), namespace = _c[0], externalDmn = _c[1];
        ackRequirementEdges(definitions["@_namespace"], externalDmn.model.definitions["@_namespace"], externalDmn.model.definitions.drgElement, ackEdge);
        return acc.set(namespace, ((_b = externalDmn.model.definitions.drgElement) !== null && _b !== void 0 ? _b : []).reduce(function (acc, e, index) { return acc.set(e["@_id"], { element: e, index: index }); }, new Map()));
    }, new Map());
    var externalNodes = __spreadArray([], __read(indexedDrd.dmnShapesByHref.entries()), false).flatMap(function (_a) {
        var _b = __read(_a, 2), href = _b[0], shape = _b[1];
        if (nodesById.get(href)) {
            return [];
        }
        if (!nodesById.get(href) && !indexedDrd.hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects.has(href)) {
            console.warn("DMN DIAGRAM: Found a shape that references a local DRG element that doesn't exist.", shape);
            var newNode_1 = ackNode(shape.dmnElementRefQName, null, -1);
            return newNode_1 ? [newNode_1] : [];
        }
        var namespace = definitions["@_xmlns:".concat(shape.dmnElementRefQName.prefix)];
        if (!namespace) {
            console.warn("DMN DIAGRAM: Found a shape that references an external node with a namespace that is not declared at this DMN.", shape);
            var newNode_2 = ackNode(shape.dmnElementRefQName, null, -1);
            return newNode_2 ? [newNode_2] : [];
        }
        var externalDrgElementsById = externalDrgElementsByIdByNamespace.get(namespace);
        if (!externalDrgElementsById) {
            console.warn("DMN DIAGRAM: Found a shape that references an external node from a namespace that is not provided on this DMN's external DMNs mapping.", shape);
            var newNode_3 = ackNode(shape.dmnElementRefQName, null, -1);
            return newNode_3 ? [newNode_3] : [];
        }
        var externalDrgElement = externalDrgElementsById.get(shape.dmnElementRefQName.localPart);
        if (!externalDrgElement) {
            console.warn("DMN DIAGRAM: Found a shape that references a non-existent node from an external DMN.", shape);
            var newNode_4 = ackNode(shape.dmnElementRefQName, null, -1);
            return newNode_4 ? [newNode_4] : [];
        }
        var newNode = ackNode(shape.dmnElementRefQName, externalDrgElement.element, externalDrgElement.index);
        return newNode ? [newNode] : [];
    });
    var sortedNodes = __spreadArray(__spreadArray([], __read(localNodes), false), __read(externalNodes), false).sort(function (a, b) { return Number(b.type === NODE_TYPES.decisionService) - Number(a.type === NODE_TYPES.decisionService); })
        .sort(function (a, b) { return Number(b.type === NODE_TYPES.group) - Number(a.type === NODE_TYPES.group); });
    var sortedEdges = edges
        .filter(function (e) { return nodesById.has(e.source) && nodesById.has(e.target); })
        .sort(function (a, b) { return Number(selectedEdges.has(a.id)) - Number(selectedEdges.has(b.id)); });
    try {
        for (var sortedNodes_1 = __values(sortedNodes), sortedNodes_1_1 = sortedNodes_1.next(); !sortedNodes_1_1.done; sortedNodes_1_1 = sortedNodes_1.next()) {
            var node = sortedNodes_1_1.value;
            try {
                for (var _j = (e_2 = void 0, __values((_g = (_f = drgAdjacencyList.get(node.id)) === null || _f === void 0 ? void 0 : _f.dependencies) !== null && _g !== void 0 ? _g : new Set())), _k = _j.next(); !_k.done; _k = _j.next()) {
                    var dependencyNodeId = _k.value;
                    if (!nodesById.get(dependencyNodeId)) {
                        node.data.hasHiddenRequirements = true;
                        break;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_k && !_k.done && (_b = _j.return)) _b.call(_j);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (sortedNodes_1_1 && !sortedNodes_1_1.done && (_a = sortedNodes_1.return)) _a.call(sortedNodes_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (diagram.overlays.enableNodeHierarchyHighlight) {
        assignClassesToHighlightedHierarchyNodes(diagram._selectedNodes, nodesById, edgesById, drgEdges);
    }
    for (var i = 0; i < sortedNodes.length; i++) {
        var parentNodeData = parentIdsById.get(sortedNodes[i].id);
        if (parentNodeData) {
            sortedNodes[i].data.parentRfNode = nodesById.get(buildXmlHref({ namespace: parentNodeData.dmnObjectNamespace, id: parentNodeData.dmnObjectQName.localPart }));
            sortedNodes[i].extent = undefined;
            sortedNodes[i].zIndex = NODE_LAYERS.NESTED_NODES;
        }
        if (sortedNodes[i].type === NODE_TYPES.group) {
            sortedNodes[i].zIndex = NODE_LAYERS.GROUP_NODE;
        }
        else if (sortedNodes[i].type === NODE_TYPES.decisionService) {
            sortedNodes[i].zIndex = NODE_LAYERS.DECISION_SERVICE_NODE;
        }
    }
    return {
        drgEdges: drgEdges,
        drgAdjacencyList: drgAdjacencyList,
        nodes: sortedNodes,
        edges: sortedEdges,
        edgesById: edgesById,
        externalNodesByNamespace: externalNodesByNamespace,
        edgesFromExternalNodesByNamespace: edgesFromExternalNodesByNamespace,
        nodesById: nodesById,
        selectedNodeTypes: selectedNodeTypes,
        selectedNodesById: selectedNodesById,
        selectedEdgesById: selectedEdgesById,
        drgElementsWithoutVisualRepresentationOnCurrentDrd: drgElementsWithoutVisualRepresentationOnCurrentDrd,
    };
}
function ackRequirementEdges(thisDmnsNamespace, drgElementsNamespace, drgElements, ackEdge) {
    var e_3, _a;
    var _b, _c, _d;
    var namespace = drgElementsNamespace === thisDmnsNamespace ? "" : drgElementsNamespace;
    var _loop_1 = function (dmnObject) {
        if (dmnObject.__$$element === "decision") {
            ((_b = dmnObject.informationRequirement) !== null && _b !== void 0 ? _b : []).forEach(function (ir, index) {
                var _a, _b, _c;
                var irHref = parseXmlHref(((_a = ir.requiredDecision) !== null && _a !== void 0 ? _a : ir.requiredInput)["@_href"]);
                ackEdge({
                    id: ir["@_id"],
                    dmnObject: {
                        namespace: drgElementsNamespace,
                        type: dmnObject.__$$element,
                        id: dmnObject["@_id"],
                        requirementType: "informationRequirement",
                        index: index,
                    },
                    type: EDGE_TYPES.informationRequirement,
                    source: buildXmlHref({ namespace: (_b = irHref.namespace) !== null && _b !== void 0 ? _b : namespace, id: irHref.id }),
                    target: buildXmlHref({ namespace: namespace, id: dmnObject["@_id"] }),
                    sourceNamespace: (_c = irHref.namespace) !== null && _c !== void 0 ? _c : namespace,
                });
            });
        }
        if (dmnObject.__$$element === "decision" || dmnObject.__$$element === "businessKnowledgeModel") {
            ((_c = dmnObject.knowledgeRequirement) !== null && _c !== void 0 ? _c : []).forEach(function (kr, index) {
                var _a, _b;
                var krHref = parseXmlHref(kr.requiredKnowledge["@_href"]);
                ackEdge({
                    id: kr["@_id"],
                    dmnObject: {
                        namespace: drgElementsNamespace,
                        type: dmnObject.__$$element,
                        id: dmnObject["@_id"],
                        requirementType: "knowledgeRequirement",
                        index: index,
                    },
                    type: EDGE_TYPES.knowledgeRequirement,
                    source: buildXmlHref({ namespace: (_a = krHref.namespace) !== null && _a !== void 0 ? _a : namespace, id: krHref.id }),
                    target: buildXmlHref({ namespace: namespace, id: dmnObject["@_id"] }),
                    sourceNamespace: (_b = krHref.namespace) !== null && _b !== void 0 ? _b : namespace,
                });
            });
        }
        if (dmnObject.__$$element === "decision" ||
            dmnObject.__$$element === "businessKnowledgeModel" ||
            dmnObject.__$$element === "knowledgeSource") {
            ((_d = dmnObject.authorityRequirement) !== null && _d !== void 0 ? _d : []).forEach(function (ar, index) {
                var _a, _b, _c, _d;
                var arHref = parseXmlHref(((_b = (_a = ar.requiredInput) !== null && _a !== void 0 ? _a : ar.requiredDecision) !== null && _b !== void 0 ? _b : ar.requiredAuthority)["@_href"]);
                ackEdge({
                    id: ar["@_id"],
                    dmnObject: {
                        namespace: drgElementsNamespace,
                        type: dmnObject.__$$element,
                        id: dmnObject["@_id"],
                        requirementType: "authorityRequirement",
                        index: index,
                    },
                    type: EDGE_TYPES.authorityRequirement,
                    source: buildXmlHref({ namespace: (_c = arHref.namespace) !== null && _c !== void 0 ? _c : namespace, id: arHref.id }),
                    target: buildXmlHref({ namespace: namespace, id: dmnObject["@_id"] }),
                    sourceNamespace: (_d = arHref.namespace) !== null && _d !== void 0 ? _d : namespace,
                });
            });
        }
    };
    try {
        for (var _e = __values(drgElements !== null && drgElements !== void 0 ? drgElements : []), _f = _e.next(); !_f.done; _f = _e.next()) {
            var dmnObject = _f.value;
            _loop_1(dmnObject);
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
        }
        finally { if (e_3) throw e_3.error; }
    }
}
export function assignClassesToHighlightedHierarchyNodes(selected, nodesById, edgesById, drgEdges) {
    var nodeVisitor = function (nodeId, traversalDirection) {
        var node = nodesById.get(nodeId);
        if (node) {
            node.className = "hierarchy ".concat(traversalDirection);
        }
    };
    var edgeVisitor = function (edge, traversalDirection) {
        var rfEdge = edgesById.get(edge.id);
        if (rfEdge) {
            rfEdge.className = "hierarchy ".concat(traversalDirection);
        }
    };
    var __selectedSet = new Set(selected);
    var __adjMatrix = getAdjMatrix(drgEdges);
    traverse(__adjMatrix, __selectedSet, selected, "up", nodeVisitor, edgeVisitor);
    traverse(__adjMatrix, __selectedSet, selected, "down", nodeVisitor, edgeVisitor);
}
//# sourceMappingURL=computeDiagramData.js.map