import { jsx as _jsx } from "react/jsx-runtime";
import { BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, } from "../../api";
import { BeeTable } from "../../table/BeeTable";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { useCallback, useMemo, useRef } from "react";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { BeeTableReadOnlyCell } from "../../table/BeeTable/BeeTableReadOnlyCell";
import { IteratorExpressionCell } from "./IteratorExpressionCell";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { NestedExpressionContainerContext } from "../../resizing/NestedExpressionContainerContext";
import { useNestedExpressionContainerWithNestedExpressions } from "../../resizing/Hooks";
import { ITERATOR_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, ITERATOR_EXPRESSION_EXTRA_WIDTH, ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH, } from "../../resizing/WidthConstants";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { IteratorExpressionVariableCell } from "./IteratorExpressionVariableCell";
export function IteratorExpressionComponent({ isNested, parentElementId, expression: expression, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { expressionHolderId, widthsById } = useBoxedExpressionEditor();
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const id = expression["@_id"];
    const tableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = expression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                isRowIndexColumn: false,
                dataType: (_b = expression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                width: undefined,
                columns: [
                    {
                        accessor: "label",
                        label: "label",
                        width: ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH,
                        minWidth: ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH,
                        isInlineEditable: false,
                        isRowIndexColumn: false,
                        isWidthPinned: true,
                        isWidthConstant: true,
                        dataType: undefined,
                    },
                    {
                        accessor: "child",
                        label: "child",
                        width: undefined,
                        minWidth: ITERATOR_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH,
                        isInlineEditable: false,
                        isRowIndexColumn: false,
                        dataType: undefined,
                    },
                ],
            },
        ];
    }, [expression, expressionHolderId]);
    const headerVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.None : BeeTableHeaderVisibility.SecondToLastLevel;
    }, [isNested]);
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.contextEntry,
                items: [{ name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset }],
            },
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [{ name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy }],
            },
        ];
    }, [i18n]);
    const getIterableRowLabel = useCallback((rowNumber) => {
        if (rowNumber === 0) {
            if (expression.__$$element === "for") {
                return "for";
            }
            else if (expression.__$$element === "some") {
                return "some";
            }
            else if (expression.__$$element === "every") {
                return "every";
            }
            else {
                throw new Error("Unknown IteratorExpression element");
            }
        }
        else if (rowNumber === 1) {
            return "in";
        }
        else if (rowNumber === 2) {
            if (expression.__$$element === "for") {
                return "return";
            }
            else if (expression.__$$element === "some" || expression.__$$element === "every") {
                return "satisfies";
            }
            else {
                throw new Error("Unknown IteratorExpression element");
            }
        }
        else {
            throw new Error("IteratorExpression can't have more than 3 rows.");
        }
    }, [expression.__$$element]);
    const getIterableRowElement = useCallback((rowNumber) => {
        var _a;
        if (rowNumber === 0) {
            return (_a = expression["@_iteratorVariable"]) !== null && _a !== void 0 ? _a : "";
        }
        else if (rowNumber === 1) {
            return expression.in;
        }
        else {
            switch (expression.__$$element) {
                case "for":
                    return expression.return;
                case "every":
                case "some":
                    return expression.satisfies;
            }
        }
    }, [expression]);
    const tableRows = useMemo(() => {
        return [
            { label: getIterableRowLabel(0), child: getIterableRowElement(0) },
            { label: getIterableRowLabel(1), child: getIterableRowElement(1) },
            { label: getIterableRowLabel(2), child: getIterableRowElement(2) },
        ];
    }, [getIterableRowElement, getIterableRowLabel]);
    const allowedOperations = useCallback(() => {
        return [BeeTableOperation.SelectionCopy, BeeTableOperation.RowReset];
    }, []);
    const beeTableRef = useRef(null);
    const cellComponentByColumnAccessor = useMemo(() => {
        return {
            label: (props) => {
                return _jsx(BeeTableReadOnlyCell, { value: props.data[props.rowIndex].label });
            },
            child: (props) => {
                if (props.rowIndex === 0) {
                    return (_jsx(IteratorExpressionVariableCell, { data: props.data, rowIndex: props.rowIndex, columnIndex: props.columnIndex, currentElementId: id, beeTableRef: beeTableRef }));
                }
                else if (props.rowIndex === 1 || props.rowIndex === 2) {
                    return (_jsx(IteratorExpressionCell, Object.assign({ iteratorClause: props.data[props.rowIndex] }, props, { parentElementId: parentElementId })));
                }
                else {
                    throw new Error("IteratorExpression can't have more than 3 rows.");
                }
            },
        };
    }, [id, parentElementId]);
    const { nestedExpressionContainerValue, onColumnResizingWidthChange } = useNestedExpressionContainerWithNestedExpressions(useMemo(() => {
        const nestedExpressions = [
            expression.in.expression,
            expression.__$$element === "for" ? expression.return.expression : expression.satisfies.expression,
        ];
        return {
            nestedExpressions: nestedExpressions,
            fixedColumnActualWidth: ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH,
            fixedColumnResizingWidth: { value: ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH, isPivoting: false },
            fixedColumnMinWidth: ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH,
            nestedExpressionMinWidth: ITERATOR_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH,
            extraWidth: ITERATOR_EXPRESSION_EXTRA_WIDTH,
            expression: expression,
            flexibleColumnIndex: 2,
            widthsById: widthsById,
        };
    }, [expression, widthsById]));
    const onColumnUpdates = useCallback(([{ name, typeRef }]) => {
        setExpression((prev) => {
            const ret = Object.assign(Object.assign({}, prev), { "@_label": name, "@_typeRef": typeRef });
            return ret;
        });
    }, [setExpression]);
    const onRowReset = useCallback((args) => {
        setExpression((prev) => {
            if (args.rowIndex === 0) {
                const ret = Object.assign(Object.assign({}, prev), { "@_iteratorVariable": undefined });
                return ret;
            }
            else if (args.rowIndex === 1) {
                const ret = Object.assign(Object.assign({}, prev), { in: { expression: undefined } });
                return ret;
            }
            else if (args.rowIndex === 2) {
                if (prev.__$$element === "for") {
                    const ret = Object.assign(Object.assign({}, prev), { return: { expression: undefined } });
                    return ret;
                }
                else if (prev.__$$element === "some" || prev.__$$element === "every") {
                    const iterator = Object.assign(Object.assign({}, prev), { satisfies: { expression: undefined } });
                    return iterator;
                }
                else {
                    throw new Error("Nested expression type not supported in IteratorExpression.");
                }
            }
            else {
                throw new Error("IteratorExpression shouldn't have more than 3 rows.");
            }
        });
    }, [setExpression]);
    return (_jsx(NestedExpressionContainerContext.Provider, Object.assign({ value: nestedExpressionContainerValue }, { children: _jsx("div", { children: _jsx(BeeTable, { forwardRef: beeTableRef, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, tableId: id, headerLevelCountForAppendingRowIndexColumn: 1, headerVisibility: headerVisibility, cellComponentByColumnAccessor: cellComponentByColumnAccessor, columns: tableColumns, rows: tableRows, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, onColumnUpdates: onColumnUpdates, onRowReset: onRowReset, onColumnResizingWidthChange: onColumnResizingWidthChange, shouldRenderRowIndexColumn: false, shouldShowRowsInlineControls: false, shouldShowColumnsInlineControls: false }) }) })));
}
//# sourceMappingURL=IteratorExpressionComponent.js.map