import * as React from "react";
import { ResizerStopBehavior, ResizingWidth } from "./ResizingWidthsContext";
export declare type BeeTableResizableColumnsContextType = {
    columnResizingWidths: Map<number, ResizingWidth>;
};
export interface BeeTableResizableColumnsDispatchContextType {
    updateColumnResizingWidths(newColumnResizingWidths: Map<number, ResizingWidth | undefined>): void;
    registerResizableCellRef(columnIndex: number, ref: BeeTableResizableCellRef): BeeTableResizableCellRef;
    deregisterResizableCellRef(columnIndex: number, ref: BeeTableResizableCellRef): void;
}
export declare const BeeTableResizableColumnsContext: React.Context<BeeTableResizableColumnsContextType>;
export declare const BeeTableResizableColumnsDispatchContext: React.Context<BeeTableResizableColumnsDispatchContextType>;
export interface BeeTableResizableCellRef {
    setResizingWidth?: React.Dispatch<React.SetStateAction<ResizingWidth | undefined>>;
}
export declare type BeeTableResizingRef = BeeTableResizableColumnsDispatchContextType;
export declare const BeeTableResizableColumnsContextProvider: ({ children, onChange, resizingRef, }: React.PropsWithChildren<{
    onChange?: ((args: Map<number, ResizingWidth | undefined>) => void) | undefined;
    resizingRef: React.RefObject<BeeTableResizingRef>;
}>) => JSX.Element;
export declare function useBeeTableResizableColumnsDispatch(): BeeTableResizableColumnsDispatchContextType;
export declare function useBeeTableResizableColumns(): BeeTableResizableColumnsContextType;
export declare function useBeeTableResizableCell(columnIndex: number, resizerStopBehavior: ResizerStopBehavior, width: number | undefined, setWidth?: React.Dispatch<React.SetStateAction<number | undefined>>, initialResizingWidthValue?: number): {
    resizingWidth: ResizingWidth | undefined;
    setResizingWidth: (newResizingWidth: ResizingWidth) => void;
};
export declare function usePublishedBeeTableResizableColumns(id: string, columnCount: number, hasRowIndexColumn: boolean): {
    onColumnResizingWidthChange: (args: Map<number, ResizingWidth | undefined>) => void;
    columnResizingWidths: Map<number, ResizingWidth>;
    isPivoting: boolean;
};
//# sourceMappingURL=BeeTableResizableColumnsContext.d.ts.map