import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useEffect, useLayoutEffect, useMemo, useState } from "react";
import { assertUnreachable } from "../expressions/ExpressionDefinitionRoot/ExpressionDefinitionLogicTypeSelector";
import { useResizingWidthsDispatch } from "../resizing/ResizingWidthsContext";
import { useBoxedExpressionEditor } from "../BoxedExpressionEditorContext";
export const SELECTION_MIN_ACTIVE_DEPTH = -1;
export const SELECTION_MIN_MAX_DEPTH = 0;
export const INITIAL_CURRENT_DEPTH = {
    active: undefined,
    max: SELECTION_MIN_MAX_DEPTH,
};
export var SelectionPart;
(function (SelectionPart) {
    SelectionPart[SelectionPart["ActiveCell"] = 0] = "ActiveCell";
    SelectionPart[SelectionPart["SelectionEnd"] = 1] = "SelectionEnd";
    SelectionPart[SelectionPart["SelectionStart"] = 2] = "SelectionStart";
})(SelectionPart || (SelectionPart = {}));
export const BeeTableSelectionContext = React.createContext({
    activeCell: undefined,
    activeCellForNestedTables: undefined,
    selectionEnd: undefined,
    selectionStart: undefined,
    currentDepth: INITIAL_CURRENT_DEPTH,
    depth: SELECTION_MIN_ACTIVE_DEPTH,
    isSelectionHere: true,
});
export const BeeTableCoordinatesContext = React.createContext({
    containerCellCoordinates: undefined,
});
export const BeeTableCoordinatesDispatchContext = React.createContext({});
export const BeeTableSelectionDispatchContext = React.createContext({});
export var BeeTableSelectionPosition;
(function (BeeTableSelectionPosition) {
    BeeTableSelectionPosition["Top"] = "top";
    BeeTableSelectionPosition["Bottom"] = "bottom";
    BeeTableSelectionPosition["Left"] = "left";
    BeeTableSelectionPosition["Right"] = "right";
})(BeeTableSelectionPosition || (BeeTableSelectionPosition = {}));
const TEXT_TO_CLIPBOARD_ROW_SEPARATOR = "\n";
const CLIPBOARD_TO_TEXT_ROW_SEPARATOR = /\r?\n/;
const CLIPBOARD_COLUMN_SEPARATOR = "\t";
const NEUTRAL_SELECTION = {
    active: undefined,
    selectionEnd: undefined,
    selectionStart: undefined,
};
const NEUTRAL_CELL_STATUS = {
    isActive: false,
    isEditing: false,
    isSelected: false,
};
const CELL_EMPTY_VALUE = "";
export function BeeTableCoordinatesContextProvider({ children, coordinates, }) {
    const { activeCell, depth } = useBeeTableSelection();
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (!activeCell && depth === SELECTION_MIN_MAX_DEPTH) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(undefined);
        }
    }, [activeCell, beeGwtService, depth]);
    const { setMaxDepth: setParentMaxDepth } = useBeeTableCoordinatesDispatch();
    const [_maxDepth, _setMaxDepth] = useState(depth);
    const { setCurrentDepth } = useBeeTableSelectionDispatch();
    const setMaxDepth = useCallback((newMaxDepthAction) => {
        setParentMaxDepth === null || setParentMaxDepth === void 0 ? void 0 : setParentMaxDepth(newMaxDepthAction);
        _setMaxDepth === null || _setMaxDepth === void 0 ? void 0 : _setMaxDepth(newMaxDepthAction);
    }, [setParentMaxDepth]);
    useEffect(() => {
        setMaxDepth((prev) => Math.max(prev, depth));
    }, [coordinates.columnIndex, coordinates.rowIndex, depth, setMaxDepth]);
    useEffect(() => {
        if (coincides(activeCell, coordinates)) {
            setCurrentDepth((prev) => ({
                active: prev.active,
                max: _maxDepth,
            }));
        }
    }, [_maxDepth, activeCell, coordinates, depth, setCurrentDepth]);
    const value = useMemo(() => {
        return {
            containerCellCoordinates: coordinates,
        };
    }, [coordinates]);
    const dispatch = useMemo(() => {
        return {
            setMaxDepth,
        };
    }, [setMaxDepth]);
    return (_jsx(BeeTableCoordinatesContext.Provider, Object.assign({ value: value }, { children: _jsx(BeeTableCoordinatesDispatchContext.Provider, Object.assign({ value: dispatch }, { children: children })) })));
}
export function BeeTableSelectionContextProvider({ children }) {
    var _a, _b, _c;
    const refs = React.useRef(new Map());
    const [_selection, _setSelection] = useState(NEUTRAL_SELECTION);
    const [_currentDepth, _setCurrentDepth] = useState(INITIAL_CURRENT_DEPTH);
    const { isSelectionHere: isParentSelectionThere, activeCellForNestedTables: parentActiveCell, currentDepth: parentCurrentDepth, depth: parentDepth, } = useBeeTableSelection();
    const { setCurrentDepth: setParentCurrentDepth, resetSelectionAt: resetParentSelectionAt } = useBeeTableSelectionDispatch();
    const { containerCellCoordinates } = useBeeTableCoordinates();
    const depth = parentDepth + 1;
    const activeDepth = (_a = parentCurrentDepth.active) !== null && _a !== void 0 ? _a : _currentDepth.active;
    const activeMaxDepth = Math.max(parentCurrentDepth.max, _currentDepth.max);
    const setCurrentDepth = setParentCurrentDepth !== null && setParentCurrentDepth !== void 0 ? setParentCurrentDepth : _setCurrentDepth;
    const isSelectionHere = useMemo(() => {
        return coincides(parentActiveCell, containerCellCoordinates) && isParentSelectionThere;
    }, [containerCellCoordinates, isParentSelectionThere, parentActiveCell]);
    const selection = useMemo(() => {
        if (depth === activeDepth && isSelectionHere) {
            return _selection;
        }
        return NEUTRAL_SELECTION;
    }, [_selection, activeDepth, depth, isSelectionHere]);
    const selectionRef = React.useRef(selection);
    useEffect(() => {
        selectionRef.current = selection;
    }, [selection]);
    const [pasteData, setPasteData] = useState("");
    useEffect(() => {
        var _a, _b, _c, _d, _e;
        if (!pasteData) {
            return;
        }
        const clipboardValue = pasteData;
        if (!((_a = selectionRef.current) === null || _a === void 0 ? void 0 : _a.selectionStart) || !((_b = selectionRef.current) === null || _b === void 0 ? void 0 : _b.selectionEnd)) {
            return;
        }
        const clipboardMatrix = clipboardValue
            .split(CLIPBOARD_TO_TEXT_ROW_SEPARATOR)
            .map((r) => r.split(CLIPBOARD_COLUMN_SEPARATOR));
        const { startRow, endRow, startColumn, endColumn } = getSelectionIterationBoundaries(selectionRef.current);
        const pasteEndRow = Math.max(endRow, startRow + clipboardMatrix.length - 1);
        const pasteEndColumn = Math.max(endColumn, startColumn + clipboardMatrix[0].length - 1);
        for (let r = startRow; r <= pasteEndRow; r++) {
            for (let c = startColumn; c <= pasteEndColumn; c++) {
                (_e = (_d = (_c = refs.current) === null || _c === void 0 ? void 0 : _c.get(r)) === null || _d === void 0 ? void 0 : _d.get(c)) === null || _e === void 0 ? void 0 : _e.forEach((e) => { var _a, _b; return (_a = e.setValue) === null || _a === void 0 ? void 0 : _a.call(e, (_b = clipboardMatrix[r - startRow]) === null || _b === void 0 ? void 0 : _b[c - startColumn]); });
            }
        }
        _setSelection({
            active: {
                rowIndex: startRow,
                columnIndex: startColumn,
                isEditing: false,
            },
            selectionStart: {
                rowIndex: startRow,
                columnIndex: startColumn,
                isEditing: false,
            },
            selectionEnd: {
                rowIndex: pasteEndRow,
                columnIndex: pasteEndColumn,
                isEditing: false,
            },
        });
        setPasteData("");
    }, [pasteData]);
    const value = useMemo(() => {
        return {
            activeCell: selection.active,
            selectionStart: selection.selectionStart,
            selectionEnd: selection.selectionEnd,
            activeCellForNestedTables: _selection.active,
            currentDepth: {
                active: activeDepth,
                max: activeMaxDepth,
            },
            depth,
            isSelectionHere,
        };
    }, [
        _selection.active,
        activeDepth,
        activeMaxDepth,
        depth,
        isSelectionHere,
        selection.active,
        selection.selectionEnd,
        selection.selectionStart,
    ]);
    const dispatch = useMemo(() => {
        return {
            setCurrentDepth: (newCurrentDepthAction) => {
                setCurrentDepth((prev) => {
                    var _a;
                    const newCurrentDepth = typeof newCurrentDepthAction === "function"
                        ? newCurrentDepthAction(prev !== null && prev !== void 0 ? prev : SELECTION_MIN_ACTIVE_DEPTH)
                        : newCurrentDepthAction;
                    return {
                        max: Math.max(SELECTION_MIN_MAX_DEPTH, newCurrentDepth.max),
                        active: (_a = newCurrentDepth.active) !== null && _a !== void 0 ? _a : SELECTION_MIN_ACTIVE_DEPTH,
                    };
                });
            },
            mutateSelection: ({ part, columnCount, rowCount, deltaColumns, deltaRows, isEditingActiveCell, keepInsideSelection, }) => {
                _setSelection((prev) => {
                    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
                    if (!prev.active) {
                        return prev;
                    }
                    const isExpanded = isSelectionExpanded(prev);
                    const { startRow, startColumn, endRow, endColumn } = getSelectionIterationBoundaries(prev);
                    const boundaries = isExpanded && keepInsideSelection
                        ? {
                            rows: { min: startRow, max: endRow },
                            columns: { min: startColumn, max: endColumn },
                        }
                        : {
                            rows: { min: 0, max: rowCount - 1 },
                            columns: { min: 1, max: columnCount(prev.active.rowIndex) - 1 },
                        };
                    const prevCoords = part === SelectionPart.ActiveCell
                        ? {
                            rowIndex: prev.active.rowIndex,
                            columnIndex: prev.active.columnIndex,
                        }
                        : part === SelectionPart.SelectionEnd
                            ? {
                                rowIndex: (_a = prev.selectionEnd) === null || _a === void 0 ? void 0 : _a.rowIndex,
                                columnIndex: (_b = prev.selectionEnd) === null || _b === void 0 ? void 0 : _b.columnIndex,
                            }
                            : part === SelectionPart.SelectionStart
                                ? {
                                    rowIndex: (_c = prev.selectionStart) === null || _c === void 0 ? void 0 : _c.rowIndex,
                                    columnIndex: (_d = prev.selectionStart) === null || _d === void 0 ? void 0 : _d.columnIndex,
                                }
                                : (() => {
                                    throw new Error("Impossible case for SelectionPart");
                                })();
                    const newRowIndex = ((_e = prevCoords.rowIndex) !== null && _e !== void 0 ? _e : 0) < 0
                        ? (_f = prevCoords.rowIndex) !== null && _f !== void 0 ? _f : 0
                        : Math.min(boundaries.rows.max, Math.max(boundaries.rows.min, ((_g = prevCoords.rowIndex) !== null && _g !== void 0 ? _g : 0) + deltaRows));
                    const newColumnIndex = prevCoords.columnIndex === 0
                        ? prevCoords.columnIndex
                        : Math.min(boundaries.columns.max, Math.max(boundaries.columns.min, ((_h = prevCoords.columnIndex) !== null && _h !== void 0 ? _h : 0) + deltaColumns));
                    switch (part) {
                        case SelectionPart.SelectionEnd:
                            return Object.assign(Object.assign({}, prev), { selectionEnd: {
                                    rowIndex: newRowIndex,
                                    columnIndex: newColumnIndex,
                                    isEditing: (_k = (_j = prev.selectionEnd) === null || _j === void 0 ? void 0 : _j.isEditing) !== null && _k !== void 0 ? _k : false,
                                } });
                        case SelectionPart.SelectionStart:
                            return Object.assign(Object.assign({}, prev), { selectionStart: {
                                    rowIndex: newRowIndex,
                                    columnIndex: newColumnIndex,
                                    isEditing: (_m = (_l = prev.selectionStart) === null || _l === void 0 ? void 0 : _l.isEditing) !== null && _m !== void 0 ? _m : false,
                                } });
                        case SelectionPart.ActiveCell:
                            if (!isExpanded || !keepInsideSelection) {
                                return {
                                    active: {
                                        rowIndex: newRowIndex,
                                        columnIndex: newColumnIndex,
                                        isEditing: isEditingActiveCell,
                                    },
                                    selectionEnd: {
                                        rowIndex: newRowIndex,
                                        columnIndex: newColumnIndex,
                                        isEditing: false,
                                    },
                                    selectionStart: {
                                        rowIndex: newRowIndex,
                                        columnIndex: newColumnIndex,
                                        isEditing: false,
                                    },
                                };
                            }
                            const targetRow = prev.active.rowIndex + deltaRows;
                            const targetColumn = prev.active.columnIndex + deltaColumns;
                            if (targetRow > boundaries.rows.max) {
                                const nextColumn = prev.active.columnIndex + 1;
                                return Object.assign(Object.assign({}, prev), { active: {
                                        rowIndex: boundaries.rows.min,
                                        columnIndex: nextColumn > boundaries.columns.max ? boundaries.columns.min : nextColumn,
                                        isEditing: isEditingActiveCell,
                                    } });
                            }
                            else if (targetColumn < boundaries.columns.min) {
                                const previousRow = prev.active.rowIndex - 1;
                                return Object.assign(Object.assign({}, prev), { active: {
                                        rowIndex: previousRow < boundaries.rows.min ? boundaries.rows.max : previousRow,
                                        columnIndex: boundaries.columns.max,
                                        isEditing: isEditingActiveCell,
                                    } });
                            }
                            else if (targetColumn > boundaries.columns.max) {
                                const nextRow = prev.active.rowIndex + 1;
                                return Object.assign(Object.assign({}, prev), { active: {
                                        rowIndex: nextRow > boundaries.rows.max ? boundaries.rows.min : nextRow,
                                        columnIndex: boundaries.columns.min,
                                        isEditing: isEditingActiveCell,
                                    } });
                            }
                            else if (targetRow < boundaries.rows.min) {
                                const previousColumn = prev.active.columnIndex - 1;
                                return Object.assign(Object.assign({}, prev), { active: {
                                        rowIndex: boundaries.rows.max,
                                        columnIndex: previousColumn < boundaries.columns.min ? boundaries.columns.max : previousColumn,
                                        isEditing: isEditingActiveCell,
                                    } });
                            }
                            else {
                                return Object.assign(Object.assign({}, prev), { active: {
                                        rowIndex: newRowIndex,
                                        columnIndex: newColumnIndex,
                                        isEditing: isEditingActiveCell,
                                    } });
                            }
                        default:
                            assertUnreachable(part);
                    }
                });
            },
            adaptSelection: ({ atRowIndex, rowCountDelta, atColumnIndex, columnCountDelta, }) => {
                _setSelection((prev) => {
                    if (!prev || !prev.active || !prev.selectionStart || !prev.selectionEnd) {
                        return prev;
                    }
                    let moveRows = 0;
                    let growRows = 0;
                    let activeMoveRows = 0;
                    if (atRowIndex >= 0) {
                        if (atRowIndex <= prev.selectionStart.rowIndex) {
                            moveRows = rowCountDelta;
                        }
                        else if (atRowIndex <= prev.selectionEnd.rowIndex) {
                            growRows = rowCountDelta;
                        }
                        if (atRowIndex <= prev.active.rowIndex) {
                            activeMoveRows = rowCountDelta;
                        }
                    }
                    let moveColumns = 0;
                    let growColumns = 0;
                    let activeMoveColumns = 0;
                    if (atColumnIndex >= 0) {
                        if (atColumnIndex <= prev.selectionStart.columnIndex) {
                            moveColumns = columnCountDelta;
                        }
                        else if (atColumnIndex <= prev.selectionEnd.columnIndex) {
                            growColumns = columnCountDelta;
                        }
                        if (atColumnIndex <= prev.active.columnIndex) {
                            activeMoveColumns = columnCountDelta;
                        }
                    }
                    return {
                        active: {
                            rowIndex: prev.active.rowIndex + activeMoveRows,
                            columnIndex: prev.active.columnIndex + activeMoveColumns,
                            isEditing: prev.active.isEditing,
                        },
                        selectionStart: {
                            rowIndex: prev.selectionStart.rowIndex + moveRows,
                            columnIndex: prev.selectionStart.columnIndex + moveColumns,
                            isEditing: prev.selectionStart.isEditing,
                        },
                        selectionEnd: {
                            rowIndex: prev.selectionEnd.rowIndex + moveRows + growRows,
                            columnIndex: prev.selectionEnd.columnIndex + moveColumns + growColumns,
                            isEditing: prev.selectionEnd.isEditing,
                        },
                    };
                });
            },
            copy: () => {
                var _a, _b, _c, _d, _e, _f, _g;
                var _h;
                if (!((_a = selectionRef.current) === null || _a === void 0 ? void 0 : _a.selectionStart) || !((_b = selectionRef.current) === null || _b === void 0 ? void 0 : _b.selectionEnd)) {
                    return;
                }
                const clipboardMatrix = [];
                const { startRow, endRow, startColumn, endColumn } = getSelectionIterationBoundaries(selectionRef.current);
                for (let r = startRow; r <= endRow; r++) {
                    (_c = clipboardMatrix[_h = r - startRow]) !== null && _c !== void 0 ? _c : (clipboardMatrix[_h] = []);
                    for (let c = startColumn; c <= endColumn; c++) {
                        clipboardMatrix[r - startRow][c - startColumn] = (_g = [...((_f = (_e = (_d = refs.current) === null || _d === void 0 ? void 0 : _d.get(r)) === null || _e === void 0 ? void 0 : _e.get(c)) !== null && _f !== void 0 ? _f : [])]) === null || _g === void 0 ? void 0 : _g.flatMap((ref) => (ref.getValue ? [ref.getValue()] : [])).join("");
                    }
                }
                const clipboardValue = clipboardMatrix
                    .map((r) => r.join(CLIPBOARD_COLUMN_SEPARATOR))
                    .join(TEXT_TO_CLIPBOARD_ROW_SEPARATOR);
                navigator.clipboard.writeText(clipboardValue);
            },
            cut: () => {
                var _a, _b, _c, _d, _e, _f, _g;
                var _h;
                if (!((_a = selectionRef.current) === null || _a === void 0 ? void 0 : _a.selectionStart) || !((_b = selectionRef.current) === null || _b === void 0 ? void 0 : _b.selectionEnd)) {
                    return;
                }
                const clipboardMatrix = [];
                const { startRow, endRow, startColumn, endColumn } = getSelectionIterationBoundaries(selectionRef.current);
                for (let r = startRow; r <= endRow; r++) {
                    (_c = clipboardMatrix[_h = r - startRow]) !== null && _c !== void 0 ? _c : (clipboardMatrix[_h] = []);
                    for (let c = startColumn; c <= endColumn; c++) {
                        clipboardMatrix[r - startRow][c - startColumn] = (_g = [...((_f = (_e = (_d = refs.current) === null || _d === void 0 ? void 0 : _d.get(r)) === null || _e === void 0 ? void 0 : _e.get(c)) !== null && _f !== void 0 ? _f : [])]) === null || _g === void 0 ? void 0 : _g.flatMap((ref) => {
                            var _a;
                            const cellValue = ref.getValue ? [ref.getValue()] : [];
                            (_a = ref.setValue) === null || _a === void 0 ? void 0 : _a.call(ref, CELL_EMPTY_VALUE);
                            return cellValue;
                        }).join("");
                    }
                }
                const clipboardValue = clipboardMatrix
                    .map((row) => row.join(CLIPBOARD_COLUMN_SEPARATOR))
                    .join(TEXT_TO_CLIPBOARD_ROW_SEPARATOR);
                navigator.clipboard.writeText(clipboardValue);
            },
            paste: () => {
                navigator.clipboard.readText().then((clipboardValue) => {
                    setPasteData(clipboardValue);
                });
            },
            erase: () => {
                var _a, _b, _c, _d, _e;
                if (!((_a = selectionRef.current) === null || _a === void 0 ? void 0 : _a.selectionStart) || !((_b = selectionRef.current) === null || _b === void 0 ? void 0 : _b.selectionEnd)) {
                    return;
                }
                const { startRow, endRow, startColumn, endColumn } = getSelectionIterationBoundaries(selectionRef.current);
                for (let r = startRow; r <= endRow; r++) {
                    for (let c = startColumn; c <= endColumn; c++) {
                        (_e = (_d = (_c = refs.current) === null || _c === void 0 ? void 0 : _c.get(r)) === null || _d === void 0 ? void 0 : _d.get(c)) === null || _e === void 0 ? void 0 : _e.forEach((ref) => {
                            var _a;
                            (_a = ref.setValue) === null || _a === void 0 ? void 0 : _a.call(ref, CELL_EMPTY_VALUE);
                        });
                    }
                }
            },
            resetSelectionAt: (newSelectionAction) => {
                var _a, _b;
                resetParentSelectionAt === null || resetParentSelectionAt === void 0 ? void 0 : resetParentSelectionAt({
                    columnIndex: (_a = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.columnIndex) !== null && _a !== void 0 ? _a : 1,
                    rowIndex: (_b = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex) !== null && _b !== void 0 ? _b : 0,
                    isEditing: false,
                });
                if (!newSelectionAction) {
                    setCurrentDepth((prev) => ({
                        max: prev.max,
                        active: Math.max(SELECTION_MIN_ACTIVE_DEPTH, depth - 1),
                    }));
                    return;
                }
                setCurrentDepth((prev) => ({
                    max: prev.max,
                    active: depth,
                }));
                _setSelection((prev) => {
                    const newActiveCell = typeof newSelectionAction === "function"
                        ? newSelectionAction(prev.active)
                        : newSelectionAction;
                    return {
                        active: newActiveCell,
                        selectionStart: (newActiveCell === null || newActiveCell === void 0 ? void 0 : newActiveCell.keepSelection) ? prev.selectionStart : newActiveCell,
                        selectionEnd: (newActiveCell === null || newActiveCell === void 0 ? void 0 : newActiveCell.keepSelection) ? prev.selectionEnd : newActiveCell,
                    };
                });
            },
            setSelectionEnd: (newSelectionEndAction) => {
                _setSelection((prev) => {
                    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
                    const newSelectionEnd = typeof newSelectionEndAction === "function"
                        ? newSelectionEndAction(prev.selectionEnd)
                        : newSelectionEndAction;
                    if ((_a = prev.active) === null || _a === void 0 ? void 0 : _a.isEditing) {
                        return prev;
                    }
                    else if (((_c = (_b = prev.selectionEnd) === null || _b === void 0 ? void 0 : _b.rowIndex) !== null && _c !== void 0 ? _c : 0) < 0 &&
                        ((_d = newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.rowIndex) !== null && _d !== void 0 ? _d : 0) < 0 &&
                        ((_e = prev.selectionEnd) === null || _e === void 0 ? void 0 : _e.rowIndex) !== (newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.rowIndex)) {
                        return prev;
                    }
                    else if (((_g = (_f = prev.selectionEnd) === null || _f === void 0 ? void 0 : _f.rowIndex) !== null && _g !== void 0 ? _g : 0) < 0 && (newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.columnIndex) === 0) {
                        return prev;
                    }
                    else if (((_h = prev.selectionEnd) === null || _h === void 0 ? void 0 : _h.columnIndex) === 0) {
                        return Object.assign(Object.assign({}, prev), { selectionEnd: {
                                columnIndex: 0,
                                rowIndex: (_j = newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.rowIndex) !== null && _j !== void 0 ? _j : prev.selectionEnd.rowIndex,
                                isEditing: false,
                            } });
                    }
                    else if (((_l = (_k = prev.selectionEnd) === null || _k === void 0 ? void 0 : _k.rowIndex) !== null && _l !== void 0 ? _l : 0) < 0) {
                        return Object.assign(Object.assign({}, prev), { selectionEnd: {
                                columnIndex: (_m = newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.columnIndex) !== null && _m !== void 0 ? _m : 0,
                                rowIndex: (_p = (_o = prev.selectionEnd) === null || _o === void 0 ? void 0 : _o.rowIndex) !== null && _p !== void 0 ? _p : 0,
                                isEditing: false,
                            } });
                    }
                    else if ((newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.columnIndex) === 0) {
                        return Object.assign(Object.assign({}, prev), { selectionEnd: {
                                columnIndex: 1,
                                rowIndex: Math.max(0, (_q = newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.rowIndex) !== null && _q !== void 0 ? _q : 0),
                                isEditing: false,
                            } });
                    }
                    else if (((_r = newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.rowIndex) !== null && _r !== void 0 ? _r : 0) < 0) {
                        return Object.assign(Object.assign({}, prev), { selectionEnd: {
                                columnIndex: (_s = newSelectionEnd === null || newSelectionEnd === void 0 ? void 0 : newSelectionEnd.columnIndex) !== null && _s !== void 0 ? _s : 0,
                                rowIndex: 0,
                                isEditing: false,
                            } });
                    }
                    else {
                        return Object.assign(Object.assign({}, prev), { selectionEnd: newSelectionEnd });
                    }
                });
            },
            registerSelectableCellRef: (rowIndex, columnIndex, ref) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
                (_a = refs.current) === null || _a === void 0 ? void 0 : _a.set(rowIndex, (_c = (_b = refs.current) === null || _b === void 0 ? void 0 : _b.get(rowIndex)) !== null && _c !== void 0 ? _c : new Map());
                const prev = (_f = (_e = (_d = refs.current) === null || _d === void 0 ? void 0 : _d.get(rowIndex)) === null || _e === void 0 ? void 0 : _e.get(columnIndex)) !== null && _f !== void 0 ? _f : new Set();
                (_h = (_g = refs.current) === null || _g === void 0 ? void 0 : _g.get(rowIndex)) === null || _h === void 0 ? void 0 : _h.set(columnIndex, new Set([...prev, ref]));
                const isActive = coincides((_j = selectionRef.current) === null || _j === void 0 ? void 0 : _j.active, { rowIndex, columnIndex });
                (_k = ref.setStatus) === null || _k === void 0 ? void 0 : _k.call(ref, {
                    isActive,
                    isEditing: isActive && ((_o = (_m = (_l = selectionRef.current) === null || _l === void 0 ? void 0 : _l.active) === null || _m === void 0 ? void 0 : _m.isEditing) !== null && _o !== void 0 ? _o : false),
                    isSelected: !isActive && isCellSelected(rowIndex, columnIndex, selectionRef.current),
                });
                return ref;
            },
            deregisterSelectableCellRef: (rowIndex, columnIndex, ref) => {
                var _a, _b, _c, _d;
                (_a = ref.setStatus) === null || _a === void 0 ? void 0 : _a.call(ref, NEUTRAL_CELL_STATUS);
                (_d = (_c = (_b = refs.current) === null || _b === void 0 ? void 0 : _b.get(rowIndex)) === null || _c === void 0 ? void 0 : _c.get(columnIndex)) === null || _d === void 0 ? void 0 : _d.delete(ref);
            },
        };
    }, [
        containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.columnIndex,
        containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex,
        depth,
        resetParentSelectionAt,
        setCurrentDepth,
    ]);
    useEffect(() => {
        if (!selection.active && depth === activeDepth && isSelectionHere) {
            dispatch.resetSelectionAt({
                rowIndex: 0,
                columnIndex: 1,
                isEditing: false,
            });
        }
    }, [activeDepth, containerCellCoordinates, depth, dispatch, isSelectionHere, parentActiveCell, selection]);
    useEffect(() => {
        var _a, _b, _c, _d, _e, _f, _g;
        if (!selection.active || !selection.selectionStart || !selection.selectionEnd) {
            return;
        }
        const currentRefs = refs.current;
        const active = selection.active;
        const { startRow, endRow, startColumn, endColumn } = getSelectionIterationBoundaries(selection);
        for (let r = startRow; r <= endRow; r++) {
            (_b = (_a = currentRefs
                .get(r)) === null || _a === void 0 ? void 0 : _a.get(0)) === null || _b === void 0 ? void 0 : _b.forEach((e) => { var _a; return (_a = e.setStatus) === null || _a === void 0 ? void 0 : _a.call(e, { isActive: false, isEditing: false, isSelected: true }); });
            for (let c = startColumn; c <= endColumn; c++) {
                if (startRow >= 0) {
                    (_d = (_c = currentRefs
                        .get(-1)) === null || _c === void 0 ? void 0 : _c.get(c)) === null || _d === void 0 ? void 0 : _d.forEach((e) => { var _a; return (_a = e.setStatus) === null || _a === void 0 ? void 0 : _a.call(e, { isActive: false, isEditing: false, isSelected: true }); });
                }
                const refs = (_e = currentRefs.get(r)) === null || _e === void 0 ? void 0 : _e.get(c);
                refs === null || refs === void 0 ? void 0 : refs.forEach((ref) => {
                    var _a;
                    return (_a = ref.setStatus) === null || _a === void 0 ? void 0 : _a.call(ref, {
                        isActive: false,
                        isEditing: false,
                        isSelected: true,
                        selectedPositions: getSelectedPositions(selection, { rowIndex: r, columnIndex: c }),
                    });
                });
            }
        }
        (_g = (_f = currentRefs
            .get(active.rowIndex)) === null || _f === void 0 ? void 0 : _f.get(active.columnIndex)) === null || _g === void 0 ? void 0 : _g.forEach((r) => {
            var _a, _b, _c, _d;
            return (_a = r.setStatus) === null || _a === void 0 ? void 0 : _a.call(r, {
                isActive: true,
                isEditing: (_b = active === null || active === void 0 ? void 0 : active.isEditing) !== null && _b !== void 0 ? _b : false,
                isSelected: !coincides((_c = selectionRef.current) === null || _c === void 0 ? void 0 : _c.selectionStart, (_d = selectionRef.current) === null || _d === void 0 ? void 0 : _d.selectionEnd),
            });
        });
        return () => {
            var _a, _b, _c, _d, _e, _f, _g;
            for (let r = startRow; r <= endRow; r++) {
                (_b = (_a = currentRefs
                    .get(r)) === null || _a === void 0 ? void 0 : _a.get(0)) === null || _b === void 0 ? void 0 : _b.forEach((e) => { var _a; return (_a = e.setStatus) === null || _a === void 0 ? void 0 : _a.call(e, NEUTRAL_CELL_STATUS); });
                for (let c = startColumn; c <= endColumn; c++) {
                    (_d = (_c = currentRefs
                        .get(-1)) === null || _c === void 0 ? void 0 : _c.get(c)) === null || _d === void 0 ? void 0 : _d.forEach((e) => { var _a; return (_a = e.setStatus) === null || _a === void 0 ? void 0 : _a.call(e, NEUTRAL_CELL_STATUS); });
                    const refs = (_e = currentRefs.get(r)) === null || _e === void 0 ? void 0 : _e.get(c);
                    refs === null || refs === void 0 ? void 0 : refs.forEach((ref) => { var _a; return (_a = ref.setStatus) === null || _a === void 0 ? void 0 : _a.call(ref, NEUTRAL_CELL_STATUS); });
                }
            }
            (_g = (_f = currentRefs
                .get(active.rowIndex)) === null || _f === void 0 ? void 0 : _f.get(active.columnIndex)) === null || _g === void 0 ? void 0 : _g.forEach((r) => { var _a; return (_a = r.setStatus) === null || _a === void 0 ? void 0 : _a.call(r, NEUTRAL_CELL_STATUS); });
        };
    }, [selection, (_b = selectionRef.current) === null || _b === void 0 ? void 0 : _b.selectionStart, (_c = selectionRef.current) === null || _c === void 0 ? void 0 : _c.selectionEnd]);
    return (_jsx(BeeTableSelectionContext.Provider, Object.assign({ value: value }, { children: _jsx(BeeTableSelectionDispatchContext.Provider, Object.assign({ value: dispatch }, { children: _jsx(_Fragment, { children: children }) })) })));
}
export function useBeeTableSelection() {
    return React.useContext(BeeTableSelectionContext);
}
export function useBeeTableSelectionDispatch() {
    return React.useContext(BeeTableSelectionDispatchContext);
}
export function useBeeTableCoordinates() {
    return React.useContext(BeeTableCoordinatesContext);
}
export function useBeeTableCoordinatesDispatch() {
    return React.useContext(BeeTableCoordinatesDispatchContext);
}
export function useBeeTableSelectableCellRef(rowIndex, columnIndex, setValue, getValue) {
    const { registerSelectableCellRef, deregisterSelectableCellRef } = useBeeTableSelectionDispatch();
    const [status, setStatus] = useState(NEUTRAL_CELL_STATUS);
    useLayoutEffect(() => {
        const ref = registerSelectableCellRef === null || registerSelectableCellRef === void 0 ? void 0 : registerSelectableCellRef(rowIndex, columnIndex, {
            setStatus,
            setValue,
            getValue,
        });
        return () => {
            deregisterSelectableCellRef === null || deregisterSelectableCellRef === void 0 ? void 0 : deregisterSelectableCellRef(rowIndex, columnIndex, ref);
        };
    }, [columnIndex, rowIndex, getValue, setValue, registerSelectableCellRef, deregisterSelectableCellRef]);
    return status;
}
function getSelectionIterationBoundaries(selection) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
    return {
        startColumn: Math.min((_b = (_a = selection.selectionStart) === null || _a === void 0 ? void 0 : _a.columnIndex) !== null && _b !== void 0 ? _b : 0, (_d = (_c = selection.selectionEnd) === null || _c === void 0 ? void 0 : _c.columnIndex) !== null && _d !== void 0 ? _d : 0),
        endColumn: Math.max((_f = (_e = selection.selectionStart) === null || _e === void 0 ? void 0 : _e.columnIndex) !== null && _f !== void 0 ? _f : 0, (_h = (_g = selection.selectionEnd) === null || _g === void 0 ? void 0 : _g.columnIndex) !== null && _h !== void 0 ? _h : 0),
        startRow: Math.min((_k = (_j = selection.selectionStart) === null || _j === void 0 ? void 0 : _j.rowIndex) !== null && _k !== void 0 ? _k : 0, (_m = (_l = selection.selectionEnd) === null || _l === void 0 ? void 0 : _l.rowIndex) !== null && _m !== void 0 ? _m : 0),
        endRow: Math.max((_p = (_o = selection.selectionStart) === null || _o === void 0 ? void 0 : _o.rowIndex) !== null && _p !== void 0 ? _p : 0, (_r = (_q = selection.selectionEnd) === null || _q === void 0 ? void 0 : _q.rowIndex) !== null && _r !== void 0 ? _r : 0),
    };
}
function getSelectedPositions(selection, cell) {
    const { startRow, endRow, startColumn, endColumn } = getSelectionIterationBoundaries(selection);
    return [
        ...(cell.rowIndex === startRow ? [BeeTableSelectionPosition.Top] : []),
        ...(cell.rowIndex === endRow ? [BeeTableSelectionPosition.Bottom] : []),
        ...(cell.columnIndex === startColumn ? [BeeTableSelectionPosition.Left] : []),
        ...(cell.columnIndex === endColumn ? [BeeTableSelectionPosition.Right] : []),
    ];
}
function coincides(a, b) {
    return (a === null || a === void 0 ? void 0 : a.columnIndex) === (b === null || b === void 0 ? void 0 : b.columnIndex) && (a === null || a === void 0 ? void 0 : a.rowIndex) === (b === null || b === void 0 ? void 0 : b.rowIndex);
}
function isCellSelected(row, column, current) {
    if (!current.selectionEnd && !current.selectionStart) {
        return false;
    }
    const bounds = getSelectionIterationBoundaries(current);
    return row >= bounds.startRow && row <= bounds.endRow && column >= bounds.startColumn && column <= bounds.endColumn;
}
function isSelectionExpanded(selection) {
    return !coincides(selection.active, selection.selectionEnd) || !coincides(selection.active, selection.selectionStart);
}
export function useBeeTableSelectableCell(cellRef, rowIndex, columnIndex, setValue, getValue) {
    const { isResizing } = useResizingWidthsDispatch();
    const { isActive, isEditing, isSelected, selectedPositions } = useBeeTableSelectableCellRef(rowIndex, columnIndex, setValue, getValue);
    const cssClasses = useMemo(() => {
        var _a;
        return `
      ${isActive ? "active" : ""}
      ${isEditing ? "editing" : ""} 
      ${isSelected ? "selected" : ""}
      ${((_a = selectedPositions === null || selectedPositions === void 0 ? void 0 : selectedPositions.length) !== null && _a !== void 0 ? _a : 0) <= 0 ? "middle" : selectedPositions === null || selectedPositions === void 0 ? void 0 : selectedPositions.join(" ")}
    `;
    }, [isActive, isEditing, isSelected, selectedPositions]);
    const { selectionStart, selectionEnd } = useBeeTableSelection();
    const { resetSelectionAt, setSelectionEnd } = useBeeTableSelectionDispatch();
    const onMouseDown = useCallback((e) => {
        e.stopPropagation();
        if (isCellSelected(rowIndex, columnIndex, {
            active: undefined,
            selectionEnd: selectionEnd,
            selectionStart: selectionStart,
        })) {
            if (e.button !== 0 && isSelected) {
                resetSelectionAt({
                    columnIndex,
                    rowIndex,
                    isEditing: false,
                    keepSelection: true,
                });
                return;
            }
        }
        if (!isActive && !isEditing) {
            const set = e.shiftKey ? setSelectionEnd : resetSelectionAt;
            set({
                columnIndex,
                rowIndex,
                isEditing: false,
            });
        }
    }, [
        rowIndex,
        columnIndex,
        selectionEnd,
        selectionStart,
        isActive,
        isEditing,
        isSelected,
        resetSelectionAt,
        setSelectionEnd,
    ]);
    const onDoubleClick = useCallback((e) => {
        e.stopPropagation();
        resetSelectionAt({
            columnIndex,
            rowIndex,
            isEditing: columnIndex > 0,
        });
    }, [columnIndex, rowIndex, resetSelectionAt]);
    useEffect(() => {
        function onEnter(e) {
            e.stopPropagation();
            if (e.buttons === 1 && e.button === 0 && !isResizing()) {
                setSelectionEnd({
                    columnIndex,
                    rowIndex,
                    isEditing: false,
                });
            }
        }
        const cell = cellRef.current;
        cell === null || cell === void 0 ? void 0 : cell.addEventListener("mouseenter", onEnter);
        return () => {
            cell === null || cell === void 0 ? void 0 : cell.removeEventListener("mouseenter", onEnter);
        };
    }, [columnIndex, rowIndex, resetSelectionAt, setSelectionEnd, cellRef, isResizing]);
    useLayoutEffect(() => {
        var _a;
        if (isActive && !isEditing) {
            (_a = cellRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [columnIndex, isActive, isEditing, rowIndex, cellRef]);
    return {
        cssClasses,
        onMouseDown,
        onDoubleClick,
        isActive,
    };
}
//# sourceMappingURL=BeeTableSelectionContext.js.map