import * as React from "react";
import { BeeTableHeaderVisibility, InsertRowColumnsDirection } from "../../api";
import * as ReactTable from "react-table";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
export interface BeeTableBodyProps<R extends object> {
    reactTableInstance: ReactTable.TableInstance<R>;
    headerVisibility: BeeTableHeaderVisibility;
    additionalRow?: React.ReactElement[];
    getRowKey: (row: ReactTable.Row<R>) => string;
    getColumnKey: (column: ReactTable.ColumnInstance<R>) => string;
    onDataCellClick?: (columnID: string) => void;
    onDataCellKeyUp?: (columnID: string) => void;
    onRowAdded?: (args: {
        beforeIndex: number;
        rowsCount: number;
        insertDirection: InsertRowColumnsDirection;
    }) => void;
    shouldRenderRowIndexColumn: boolean;
    shouldShowRowsInlineControls: boolean;
    resizerStopBehavior: ResizerStopBehavior;
    lastColumnMinWidth?: number;
    rowWrapper?: React.FunctionComponent<React.PropsWithChildren<{
        row: R;
        rowIndex: number;
    }>>;
}
export declare function BeeTableBody<R extends object>({ reactTableInstance, additionalRow, headerVisibility, getRowKey, getColumnKey, onRowAdded, onDataCellClick, onDataCellKeyUp, shouldRenderRowIndexColumn, shouldShowRowsInlineControls, resizerStopBehavior, lastColumnMinWidth, rowWrapper, }: BeeTableBodyProps<R>): JSX.Element;
//# sourceMappingURL=BeeTableBody.d.ts.map