import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DrilldownMenu, Menu, MenuContent, MenuGroup, MenuItem, MenuList, } from "@patternfly/react-core/dist/js/components/Menu";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import PlusIcon from "@patternfly/react-icons/dist/js/icons/plus-icon";
import TrashIcon from "@patternfly/react-icons/dist/js/icons/trash-icon";
import BlueprintIcon from "@patternfly/react-icons/dist/js/icons/blueprint-icon";
import CompressIcon from "@patternfly/react-icons/dist/js/icons/compress-icon";
import * as React from "react";
import { useCallback, useEffect, useLayoutEffect, useMemo, useState } from "react";
import { BeeTableOperation, InsertRowColumnsDirection, } from "../../api";
import { useCustomContextMenuHandler } from "../../contextMenu";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
import { assertUnreachable } from "../../expressions/ExpressionDefinitionRoot/ExpressionDefinitionLogicTypeSelector";
import { useBeeTableSelection, useBeeTableSelectionDispatch, } from "../../selection/BeeTableSelectionContext";
import * as _ from "lodash";
import CutIcon from "@patternfly/react-icons/dist/js/icons/cut-icon";
import CopyIcon from "@patternfly/react-icons/dist/js/icons/copy-icon";
import PasteIcon from "@patternfly/react-icons/dist/js/icons/paste-icon";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { NumberInput, Radio } from "@patternfly/react-core/dist/js/";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import "./BeeTableContextMenuHandler.css";
const MAXIMUM_ROWS_COLUMNS_PER_INSERTION = 500;
const DEFAULT_MULTIPLE_ROWS_COLUMNS_INSERTION = 2;
export function BeeTableContextMenuHandler({ tableRef, operationConfig, allowedOperations, reactTableInstance, onRowAdded, onRowDuplicated, onRowDeleted, onRowReset, onColumnAdded, onColumnDeleted, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { setCurrentlyOpenContextMenu } = useBoxedExpressionEditor();
    const [menuDrilledIn, setMenuDrilledIn] = useState([]);
    const [drillDownPath, setDrillDownPath] = useState([]);
    const [menuHeights, setMenuHeights] = useState({});
    const [direction, setDirection] = useState(InsertRowColumnsDirection.AboveOrRight);
    const [insertMultipleRowColumnsValue, setInsertMultipleRowColumnsValue] = React.useState(DEFAULT_MULTIPLE_ROWS_COLUMNS_INSERTION);
    const { activeCell, selectionStart, selectionEnd } = useBeeTableSelection();
    const menuId = "menu-" + (activeCell === null || activeCell === void 0 ? void 0 : activeCell.columnIndex) + "-" + (activeCell === null || activeCell === void 0 ? void 0 : activeCell.rowIndex);
    const [lastActiveMenu, setLastActiveMenu] = useState("");
    const [lastRootMenuId, setLastRootMenuId] = useState(menuId);
    const activeMenuId = useMemo(() => {
        if (menuId !== lastRootMenuId) {
            return menuId;
        }
        else {
            return lastActiveMenu;
        }
    }, [lastActiveMenu, lastRootMenuId, menuId]);
    const rootMenuId = useMemo(() => {
        if (menuId !== lastRootMenuId) {
            return menuId;
        }
        return lastRootMenuId;
    }, [lastRootMenuId, menuId]);
    useEffect(() => {
        setLastRootMenuId(menuId);
    }, [menuId]);
    useEffect(() => {
        setCurrentlyOpenContextMenu(undefined);
    }, [menuId, setCurrentlyOpenContextMenu]);
    const drillIn = useCallback((_event, fromMenuId, toMenuId, pathId) => {
        setMenuDrilledIn((prev) => [...prev, fromMenuId]);
        setDrillDownPath((prev) => [...prev, pathId]);
        setLastActiveMenu(toMenuId);
    }, []);
    const drillOut = useCallback((_event, toMenuId) => {
        setMenuDrilledIn((prev) => prev.slice(0, prev.length - 1));
        setDrillDownPath((prev) => prev.slice(0, prev.length - 1));
        setLastActiveMenu(toMenuId);
    }, []);
    const setMenuHeight = useCallback((menuId, height) => {
        setMenuHeights((prev) => {
            if (prev[menuId] === undefined || (menuId !== rootMenuId && prev[menuId] !== height)) {
                return Object.assign(Object.assign({}, prev), { [menuId]: height });
            }
            return prev;
        });
    }, [rootMenuId]);
    const selection = useMemo(() => {
        return {
            active: activeCell,
            selectionStart: selectionStart,
            selectionEnd: selectionEnd,
        };
    }, [activeCell, selectionStart, selectionEnd]);
    const { copy, cut, paste, erase } = useBeeTableSelectionDispatch();
    const columns = useMemo(() => {
        var _a;
        if (!activeCell) {
            return undefined;
        }
        const rowIndex = activeCell.rowIndex;
        return rowIndex < 0
            ? (_a = _.nth(reactTableInstance.headerGroups, rowIndex)) === null || _a === void 0 ? void 0 : _a.headers
            : reactTableInstance.allColumns;
    }, [activeCell, reactTableInstance.allColumns, reactTableInstance.headerGroups]);
    const column = useMemo(() => {
        if (!activeCell) {
            return undefined;
        }
        const columnIndex = activeCell.columnIndex;
        const rowIndex = activeCell.rowIndex;
        if (rowIndex < 0) {
            const nonPlaceholderColumns = columns === null || columns === void 0 ? void 0 : columns.filter((col) => !(col === null || col === void 0 ? void 0 : col.placeholderOf));
            if (nonPlaceholderColumns) {
                return nonPlaceholderColumns[columnIndex];
            }
            else {
                console.error(`No column found at [${rowIndex}, ${columnIndex}]`);
            }
        }
        else {
            return columns === null || columns === void 0 ? void 0 : columns[columnIndex];
        }
    }, [activeCell, columns]);
    const operationGroups = useMemo(() => {
        if (!activeCell) {
            return [];
        }
        if (_.isArray(operationConfig)) {
            return operationConfig;
        }
        return (operationConfig !== null && operationConfig !== void 0 ? operationConfig : {})[(column === null || column === void 0 ? void 0 : column.groupType) || ""];
    }, [activeCell, column === null || column === void 0 ? void 0 : column.groupType, operationConfig]);
    const allOperations = useMemo(() => {
        return operationGroups.flatMap(({ items }) => items);
    }, [operationGroups]);
    const operationLabel = useCallback((operation) => {
        switch (operation) {
            case BeeTableOperation.ColumnInsertLeft:
                return i18n.columnOperations.insertLeft;
            case BeeTableOperation.ColumnInsertRight:
                return i18n.columnOperations.insertRight;
            case BeeTableOperation.ColumnInsertN:
                return i18n.insert;
            case BeeTableOperation.ColumnDelete:
                return i18n.columnOperations.delete;
            case BeeTableOperation.RowInsertAbove:
                return i18n.rowOperations.insertAbove;
            case BeeTableOperation.RowInsertBelow:
                return i18n.rowOperations.insertBelow;
            case BeeTableOperation.RowInsertN:
                return i18n.insert;
            case BeeTableOperation.RowDelete:
                return i18n.rowOperations.delete;
            case BeeTableOperation.RowReset:
                return i18n.rowOperations.reset;
            case BeeTableOperation.RowDuplicate:
                return i18n.rowOperations.duplicate;
            case BeeTableOperation.SelectionCopy:
                return i18n.terms.copy;
            case BeeTableOperation.SelectionCut:
                return i18n.terms.cut;
            case BeeTableOperation.SelectionPaste:
                return i18n.terms.paste;
            case BeeTableOperation.SelectionReset:
                return i18n.terms.reset;
            default:
                assertUnreachable(operation);
        }
    }, [i18n]);
    const operationIcon = useCallback((operation) => {
        switch (operation) {
            case BeeTableOperation.ColumnInsertLeft:
                return _jsx(PlusIcon, {});
            case BeeTableOperation.ColumnInsertRight:
                return _jsx(PlusIcon, {});
            case BeeTableOperation.ColumnInsertN:
                return _jsx(PlusIcon, {});
            case BeeTableOperation.ColumnDelete:
                return _jsx(TrashIcon, {});
            case BeeTableOperation.RowInsertAbove:
                return _jsx(PlusIcon, {});
            case BeeTableOperation.RowInsertBelow:
                return _jsx(PlusIcon, {});
            case BeeTableOperation.RowInsertN:
                return _jsx(PlusIcon, {});
            case BeeTableOperation.RowDelete:
                return _jsx(TrashIcon, {});
            case BeeTableOperation.RowReset:
                return _jsx(CompressIcon, {});
            case BeeTableOperation.RowDuplicate:
                return _jsx(BlueprintIcon, {});
            case BeeTableOperation.SelectionCopy:
                return _jsx(CopyIcon, {});
            case BeeTableOperation.SelectionCut:
                return _jsx(CutIcon, {});
            case BeeTableOperation.SelectionPaste:
                return _jsx(PasteIcon, {});
            case BeeTableOperation.SelectionReset:
                return _jsx(CompressIcon, {});
            default:
                assertUnreachable(operation);
        }
    }, []);
    const handleOperation = useCallback((operation) => {
        if (operation === undefined || operation === null) {
            return;
        }
        if (!activeCell) {
            return [];
        }
        const rowIndex = activeCell.rowIndex;
        const columnIndex = activeCell.columnIndex;
        switch (operation) {
            case BeeTableOperation.ColumnInsertLeft:
                onColumnAdded === null || onColumnAdded === void 0 ? void 0 : onColumnAdded({
                    beforeIndex: columnIndex - 1,
                    currentIndex: columnIndex,
                    groupType: column === null || column === void 0 ? void 0 : column.groupType,
                    columnsCount: 1,
                    insertDirection: InsertRowColumnsDirection.BelowOrLeft,
                });
                console.debug(`Insert column left to ${columnIndex}`);
                break;
            case BeeTableOperation.ColumnInsertRight:
                onColumnAdded === null || onColumnAdded === void 0 ? void 0 : onColumnAdded({
                    beforeIndex: columnIndex,
                    currentIndex: columnIndex,
                    groupType: column === null || column === void 0 ? void 0 : column.groupType,
                    columnsCount: 1,
                    insertDirection: InsertRowColumnsDirection.AboveOrRight,
                });
                console.debug(`Insert column right to ${columnIndex}`);
                break;
            case BeeTableOperation.ColumnInsertN:
                if (direction === InsertRowColumnsDirection.AboveOrRight) {
                    onColumnAdded === null || onColumnAdded === void 0 ? void 0 : onColumnAdded({
                        beforeIndex: columnIndex,
                        currentIndex: columnIndex,
                        groupType: column === null || column === void 0 ? void 0 : column.groupType,
                        columnsCount: insertMultipleRowColumnsValue,
                        insertDirection: InsertRowColumnsDirection.AboveOrRight,
                    });
                }
                else {
                    onColumnAdded === null || onColumnAdded === void 0 ? void 0 : onColumnAdded({
                        beforeIndex: columnIndex - 1,
                        currentIndex: columnIndex,
                        groupType: column === null || column === void 0 ? void 0 : column.groupType,
                        columnsCount: insertMultipleRowColumnsValue,
                        insertDirection: InsertRowColumnsDirection.BelowOrLeft,
                    });
                }
                console.debug(`Insert n columns to ${columnIndex}`);
                break;
            case BeeTableOperation.ColumnDelete:
                onColumnDeleted === null || onColumnDeleted === void 0 ? void 0 : onColumnDeleted({
                    columnIndex: columnIndex - 1,
                    groupType: column === null || column === void 0 ? void 0 : column.groupType,
                });
                console.debug(`Delete column ${columnIndex}`);
                break;
            case BeeTableOperation.RowInsertAbove:
                onRowAdded === null || onRowAdded === void 0 ? void 0 : onRowAdded({
                    beforeIndex: rowIndex,
                    rowsCount: 1,
                    insertDirection: InsertRowColumnsDirection.AboveOrRight,
                });
                console.debug(`Insert row above to ${rowIndex}`);
                break;
            case BeeTableOperation.RowInsertBelow:
                onRowAdded === null || onRowAdded === void 0 ? void 0 : onRowAdded({
                    beforeIndex: rowIndex + 1,
                    rowsCount: 1,
                    insertDirection: InsertRowColumnsDirection.BelowOrLeft,
                });
                console.debug(`Insert row below to ${rowIndex}`);
                break;
            case BeeTableOperation.RowInsertN:
                if (direction === InsertRowColumnsDirection.AboveOrRight) {
                    onRowAdded === null || onRowAdded === void 0 ? void 0 : onRowAdded({
                        beforeIndex: rowIndex,
                        rowsCount: insertMultipleRowColumnsValue,
                        insertDirection: InsertRowColumnsDirection.AboveOrRight,
                    });
                }
                else {
                    onRowAdded === null || onRowAdded === void 0 ? void 0 : onRowAdded({
                        beforeIndex: rowIndex + 1,
                        rowsCount: insertMultipleRowColumnsValue,
                        insertDirection: InsertRowColumnsDirection.BelowOrLeft,
                    });
                }
                console.debug(`Insert n rows to ${columnIndex}`);
                break;
            case BeeTableOperation.RowDelete:
                onRowDeleted === null || onRowDeleted === void 0 ? void 0 : onRowDeleted({ rowIndex: rowIndex });
                console.debug(`Delete row ${rowIndex}`);
                break;
            case BeeTableOperation.RowReset:
                onRowReset === null || onRowReset === void 0 ? void 0 : onRowReset({ rowIndex: rowIndex });
                console.debug(`Reset row ${rowIndex}`);
                break;
            case BeeTableOperation.RowDuplicate:
                onRowDuplicated === null || onRowDuplicated === void 0 ? void 0 : onRowDuplicated({ rowIndex: rowIndex });
                console.debug(`Duplicate row ${rowIndex}`);
                break;
            case BeeTableOperation.SelectionCopy:
                copy();
                console.debug(`Copying area from: [${selectionStart === null || selectionStart === void 0 ? void 0 : selectionStart.rowIndex}, ${selectionStart === null || selectionStart === void 0 ? void 0 : selectionStart.columnIndex}] to [${selectionEnd === null || selectionEnd === void 0 ? void 0 : selectionEnd.rowIndex}, ${selectionEnd === null || selectionEnd === void 0 ? void 0 : selectionEnd.columnIndex}]`);
                break;
            case BeeTableOperation.SelectionCut:
                cut();
                console.debug(`Cuting area from: [${selectionStart === null || selectionStart === void 0 ? void 0 : selectionStart.rowIndex}, ${selectionStart === null || selectionStart === void 0 ? void 0 : selectionStart.columnIndex}] to [${selectionEnd === null || selectionEnd === void 0 ? void 0 : selectionEnd.rowIndex}, ${selectionEnd === null || selectionEnd === void 0 ? void 0 : selectionEnd.columnIndex}]`);
                break;
            case BeeTableOperation.SelectionPaste:
                paste();
                console.debug(`Pasting into: [${selectionStart === null || selectionStart === void 0 ? void 0 : selectionStart.rowIndex}, ${selectionStart === null || selectionStart === void 0 ? void 0 : selectionStart.columnIndex}]`);
                break;
            case BeeTableOperation.SelectionReset:
                erase();
                console.debug(`Reseting area from: [${selectionStart === null || selectionStart === void 0 ? void 0 : selectionStart.rowIndex}, ${selectionStart === null || selectionStart === void 0 ? void 0 : selectionStart.columnIndex}] to [${selectionEnd === null || selectionEnd === void 0 ? void 0 : selectionEnd.rowIndex}, ${selectionEnd === null || selectionEnd === void 0 ? void 0 : selectionEnd.columnIndex}]`);
                break;
            default:
                assertUnreachable(operation);
        }
        setCurrentlyOpenContextMenu(undefined);
    }, [
        activeCell,
        selectionStart,
        selectionEnd,
        setCurrentlyOpenContextMenu,
        onColumnAdded,
        column === null || column === void 0 ? void 0 : column.groupType,
        onColumnDeleted,
        onRowAdded,
        onRowDeleted,
        onRowReset,
        onRowDuplicated,
        copy,
        cut,
        paste,
        erase,
        direction,
        insertMultipleRowColumnsValue,
    ]);
    const onMinus = useCallback(() => {
        const newValue = (insertMultipleRowColumnsValue || 0) - 1;
        setInsertMultipleRowColumnsValue(newValue);
    }, [insertMultipleRowColumnsValue]);
    const onChange = useCallback((event) => {
        const value = event.target.value;
        const intValue = Math.abs(parseInt(value));
        setInsertMultipleRowColumnsValue(intValue === 0 ? 1 : Math.min(intValue, MAXIMUM_ROWS_COLUMNS_PER_INSERTION));
    }, []);
    const onPlus = useCallback(() => {
        const newValue = (insertMultipleRowColumnsValue || 0) + 1;
        setInsertMultipleRowColumnsValue(newValue);
    }, [insertMultipleRowColumnsValue]);
    const insertRowColumnsNumberInput = useMemo(() => {
        return (_jsx(NumberInput, { value: insertMultipleRowColumnsValue, onMinus: onMinus, onChange: onChange, onPlus: onPlus, inputName: "input", inputAriaLabel: "number input", minusBtnAriaLabel: "minus", plusBtnAriaLabel: "plus", allowEmptyInput: false, min: 1, max: MAXIMUM_ROWS_COLUMNS_PER_INSERTION, style: { textAlign: "center" }, onDoubleClick: (e) => e.stopPropagation() }));
    }, [insertMultipleRowColumnsValue, onMinus, onChange, onPlus]);
    const contextMenuContainer = React.createRef();
    const { xPos, yPos, isOpen } = useCustomContextMenuHandler(tableRef);
    const resetDrillDownMenu = useCallback(() => {
        setMenuDrilledIn([]);
        setDrillDownPath([]);
        setMenuHeights({});
        setLastActiveMenu(rootMenuId);
        setInsertMultipleRowColumnsValue(DEFAULT_MULTIPLE_ROWS_COLUMNS_INSERTION);
    }, [rootMenuId]);
    useEffect(() => {
        if (!isOpen) {
            resetDrillDownMenu();
        }
    }, [isOpen, resetDrillDownMenu]);
    const style = useMemo(() => {
        return {
            top: yPos + "px",
            left: xPos + "px",
        };
    }, [xPos, yPos]);
    useLayoutEffect(() => {
        if (contextMenuContainer.current) {
            const bounds = contextMenuContainer.current.getBoundingClientRect();
            let contextMenuHeight = menuHeights[activeMenuId];
            const availableHeight = document.documentElement.clientHeight;
            if (contextMenuHeight + yPos >= availableHeight) {
                const offset = contextMenuHeight + yPos - availableHeight;
                contextMenuHeight = contextMenuHeight - offset;
                contextMenuContainer.current.style.height = contextMenuHeight + "px";
                contextMenuContainer.current.style.overflowY = "scroll";
            }
            else {
                contextMenuContainer.current.style.overflowY = "visible";
            }
            if (contextMenuHeight <= availableHeight && contextMenuHeight + yPos > availableHeight) {
                const offset = contextMenuHeight + yPos - availableHeight;
                contextMenuContainer.current.style.top = yPos - offset + "px";
                contextMenuContainer.current.style.left = xPos + 2 + "px";
            }
            const contextMenuWidth = bounds.width;
            const availableWidth = document.documentElement.clientWidth;
            if (contextMenuWidth <= availableWidth && contextMenuWidth + xPos > availableWidth) {
                const offset = contextMenuWidth + xPos - availableWidth;
                contextMenuContainer.current.style.left = xPos - offset - 2 + "px";
            }
        }
    });
    const allowedOperationsForSelection = useMemo(() => {
        return allowedOperations({
            selection,
            column,
            columns,
        });
    }, [allowedOperations, selection, column, columns]);
    const hasAllowedOperations = useMemo(() => {
        return allOperations.some((operation) => allowedOperationsForSelection.includes(operation.type));
    }, [allOperations, allowedOperationsForSelection]);
    let countGroupsWithAllowedOperations = 0;
    function toggleInsertDirection() {
        setDirection(direction === InsertRowColumnsDirection.AboveOrRight
            ? InsertRowColumnsDirection.BelowOrLeft
            : InsertRowColumnsDirection.AboveOrRight);
    }
    function createDrillDownMenu(group, operation) {
        return (_jsxs(DrilldownMenu, Object.assign({ id: "insertNColumnsMenu" + operation.toString() }, { children: [_jsx(MenuItem, Object.assign({ direction: "up", onClick: (e) => e.stopPropagation() }, { children: "Back" })), _jsx(Divider, {}), _jsx(MenuGroup, Object.assign({ label: group }, { children: _jsxs(Flex, Object.assign({ direction: { default: "column" }, style: { padding: "16px" } }, { children: [_jsx(Flex, Object.assign({ direction: { default: "column" }, width: "300px" }, { children: _jsx(FlexItem, Object.assign({ onClick: (event) => event.stopPropagation() }, { children: insertRowColumnsNumberInput })) })), _jsx(Flex, Object.assign({ direction: { default: "row" } }, { children: _jsxs(FlexItem, Object.assign({ onClick: (event) => event.stopPropagation() }, { children: [_jsx("br", {}), _jsx(Radio, { id: "insertRightAbove" + operation, name: "insertRightAbove" + operation, label: operation === BeeTableOperation.ColumnInsertN
                                                ? i18n.insertDirections.toTheRight
                                                : i18n.insertDirections.above, onChange: toggleInsertDirection, isChecked: direction === InsertRowColumnsDirection.AboveOrRight }), _jsx(Radio, { id: "insertLeftBelow" + operation, name: "insertLeftBelow" + operation, label: operation === BeeTableOperation.ColumnInsertN
                                                ? i18n.insertDirections.toTheLeft
                                                : i18n.insertDirections.below, onChange: toggleInsertDirection, isChecked: direction === InsertRowColumnsDirection.BelowOrLeft })] })) })), _jsxs(FlexItem, Object.assign({ align: { default: "alignLeft" } }, { children: [_jsx("br", {}), _jsx(Button, Object.assign({ onClick: () => handleOperation(operation) }, { children: "Insert" }))] }))] })) }))] })));
    }
    function buildMenuList(items, group) {
        return (_jsx(MenuList, { children: items.map((operation) => operation.type === BeeTableOperation.ColumnInsertN || operation.type === BeeTableOperation.RowInsertN ? (_jsx(MenuItem, Object.assign({ icon: operationIcon(operation.type), "data-ouia-component-id": "expression-table-context-menu-" + operation.name, itemId: operation.type, isDisabled: !allowedOperationsForSelection.includes(operation.type), direction: "down", onClick: (e) => e.stopPropagation(), drilldownMenu: createDrillDownMenu(group, operation.type) }, { children: operation.name ? operation.name : operationLabel(operation.type) }), operation.type + group)) : (_jsx(MenuItem, Object.assign({ icon: operationIcon(operation.type), "data-ouia-component-id": "expression-table-context-menu-" + operation.name, itemId: operation.type, onClick: () => handleOperation(operation.type), isDisabled: !allowedOperationsForSelection.includes(operation.type) }, { children: operation.name ? operation.name : operationLabel(operation.type) }), operation.type + group))) }));
    }
    function createMenuGroup(items, group, element) {
        return (_jsxs(_Fragment, { children: [items.some((operation) => allowedOperationsForSelection.includes(operation.type)) &&
                    ++countGroupsWithAllowedOperations &&
                    countGroupsWithAllowedOperations > 1 && _jsx(Divider, { style: { padding: "16px" } }, "divider-" + group), _jsx(MenuGroup, Object.assign({ label: group, className: items.every((operation) => !allowedOperationsForSelection.includes(operation.type))
                        ? "no-allowed-actions-in-group"
                        : "" }, { children: element }))] }));
    }
    return (_jsx(_Fragment, { children: isOpen && (_jsx("div", Object.assign({ className: "context-menu-container", style: style, onMouseDown: (e) => e.stopPropagation(), ref: contextMenuContainer }, { children: _jsx(Menu, Object.assign({ ouiaId: "expression-table-context-menu", className: "table-context-menu", id: rootMenuId, containsDrilldown: true, onDrillIn: drillIn, onDrillOut: drillOut, activeMenu: activeMenuId, onGetMenuHeight: setMenuHeight, drilldownItemPath: drillDownPath, drilledInMenus: menuDrilledIn }, { children: _jsx(MenuContent, Object.assign({ menuHeight: `${menuHeights[activeMenuId]}px` }, { children: hasAllowedOperations &&
                        operationGroups.map(({ group, items }) => (_jsx(React.Fragment, { children: activeMenuId === rootMenuId
                                ? createMenuGroup(items, group, buildMenuList(items, group))
                                : buildMenuList(items, group) }, group))) })) })) }))) }));
}
//# sourceMappingURL=BeeTableContextMenuHandler.js.map