import * as React from "react";
import * as ReactTable from "react-table";
import { OnExpressionVariableUpdated } from "../../expressionVariable/ExpressionVariableMenu";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
export interface BeeTableThResizableProps<R extends object> {
    onColumnAdded?: (args: {
        beforeIndex: number;
        groupType: string | undefined;
    }) => void;
    column: ReactTable.ColumnInstance<R>;
    columnIndex: number;
    rowIndex: number;
    rowSpan: number;
    editColumnLabel?: string | {
        [groupType: string]: string;
    };
    isEditableHeader: boolean;
    getColumnKey: (column: ReactTable.ColumnInstance<R>) => string;
    getColumnLabel: (groupType: string | undefined) => string | undefined;
    onExpressionHeaderUpdated: OnExpressionVariableUpdated;
    onHeaderClick?: (columnKey: string) => void;
    onHeaderKeyUp?: (columnKey: string) => void;
    reactTableInstance: ReactTable.TableInstance<R>;
    headerCellInfo: React.ReactElement;
    shouldShowColumnsInlineControls: boolean;
    resizerStopBehavior: ResizerStopBehavior;
    lastColumnMinWidth?: number;
    onGetWidthToFitData: () => number;
    forwardRef?: React.RefObject<HTMLTableCellElement>;
    shouldRenderRowIndexColumn: boolean;
}
export declare function BeeTableThResizable<R extends object>({ column, columnIndex, rowIndex, shouldRenderRowIndexColumn, rowSpan, isEditableHeader, reactTableInstance, getColumnKey, onExpressionHeaderUpdated, onHeaderClick, onHeaderKeyUp, headerCellInfo, onColumnAdded, resizerStopBehavior, shouldShowColumnsInlineControls, lastColumnMinWidth, onGetWidthToFitData, forwardRef, }: BeeTableThResizableProps<R>): JSX.Element;
//# sourceMappingURL=BeeTableThResizable.d.ts.map