import { OpenAPI } from "openapi-types";
import { GraphQL } from "../graphql";
import { BulkWorkflowInstanceActionResponse, WorkflowInstance, WorkflowInstanceFilter, WorkflowListSortBy, WorkflowDefinition, CloudEventRequest, WorkflowResponse, JobStatus, Job, JobsSortBy, JobCancel } from "../types";
import { NodeInstance, TriggerableNode, OperationType, CustomDashboardInfo, FormInfo, Form, FormContent } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { ApolloClient } from "apollo-client";
export declare const getWorkflowInstances: (offset: number, limit: number, filters: WorkflowInstanceFilter, sortBy: WorkflowListSortBy, client: ApolloClient<any>) => Promise<WorkflowInstance[]>;
export declare const getChildWorkflowInstances: (rootWorkflowInstanceId: string, client: ApolloClient<any>) => Promise<WorkflowInstance[]>;
export declare const performMultipleCancel: (jobsToBeActioned: (GraphQL.Job & {
    errorMessage?: string;
})[], client: ApolloClient<any>) => Promise<any>;
export declare const jobCancel: (job: Pick<GraphQL.Job, "id" | "endpoint">, client: ApolloClient<any>) => Promise<JobCancel>;
export declare const handleJobReschedule: (job: any, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date, client: ApolloClient<any>) => Promise<{
    modalTitle: string;
    modalContent: string;
}>;
export declare const handleWorkflowSkip: (workflowInstance: WorkflowInstance, client: ApolloClient<any>) => Promise<void>;
export declare const handleWorkflowRetry: (workflowInstance: WorkflowInstance, client: ApolloClient<any>) => Promise<void>;
export declare const handleWorkflowAbort: (workflowInstance: WorkflowInstance, client: ApolloClient<any>) => Promise<void>;
export declare const handleWorkflowMultipleAction: (workflowInstances: WorkflowInstance[], operationType: OperationType, client: ApolloClient<any>) => Promise<BulkWorkflowInstanceActionResponse>;
export declare const handleNodeTrigger: (workflowInstance: WorkflowInstance, node: TriggerableNode, client: ApolloClient<any>) => Promise<void>;
export declare const handleWorkflowVariableUpdate: (workflowInstance: WorkflowInstance, updatedJson: Record<string, unknown>, client: ApolloClient<any>) => Promise<Record<string, unknown>>;
export declare const handleNodeInstanceCancel: (workflowInstance: WorkflowInstance, node: NodeInstance, client: ApolloClient<any>) => Promise<void>;
export declare const handleNodeInstanceRetrigger: (workflowInstance: Pick<WorkflowInstance, "id" | "serviceUrl" | "processId">, node: Pick<NodeInstance, "id">, client: ApolloClient<any>) => Promise<void>;
export declare const getWorkflowDetails: (id: string, client: ApolloClient<any>) => Promise<any>;
export declare const getJobs: (id: string, client: ApolloClient<any>) => Promise<any>;
export declare const getTriggerableNodes: (workflowInstance: WorkflowInstance, client: ApolloClient<any>) => Promise<any>;
export declare const getJobsWithFilters: (offset: number, limit: number, filters: JobStatus[], orderBy: JobsSortBy, client: ApolloClient<any>) => Promise<Job[]>;
export declare const triggerStartCloudEvent: (event: CloudEventRequest, baseUrl: string, proxyEndpoint?: string) => Promise<string>;
export declare const triggerCloudEvent: (event: CloudEventRequest, baseUrl: string, proxyEndpoint?: string) => Promise<any>;
export declare const getWorkflowDefinitions: (client: ApolloClient<any>) => Promise<WorkflowDefinition[]>;
export declare const getWorkflowSchema: (workflowDefinitionData: WorkflowDefinition) => Promise<Record<string, any>>;
export declare const startWorkflowInstance: (formData: any, businessKey: string, workflowDefinitionData: WorkflowDefinition, proxyEndpoint: string) => Promise<string>;
export declare const startWorkflowRest: (data: Record<string, any>, endpoint: string, businessKey: string, proxyEndpoint?: string) => Promise<WorkflowResponse>;
export declare const getCustomDashboard: (customDashboardFilter: string[]) => Promise<CustomDashboardInfo[]>;
export declare const getCustomDashboardContent: (name: string) => Promise<string>;
export declare const getCustomWorkflowSchemaFromApi: (api: OpenAPI.Document, workflowName: string) => Promise<Record<string, any>>;
export declare const getCustomWorkflowSchema: (baseUrl: string, openApiPath: string, workflowName: string, proxyEndpoint?: string) => Promise<Record<string, any>>;
export declare const getForms: (formFilter: string[]) => Promise<FormInfo[]>;
export declare const getFormContent: (formName: string) => Promise<Form>;
export declare const saveFormContent: (formName: string, content: FormContent) => Promise<void>;
//# sourceMappingURL=apis.d.ts.map