import { EditorLanguageServiceArgs, ELsNode, IEditorLanguageService } from "@kie-tools/json-yaml-language-service/dist/channel";
import { JSONSchema } from "vscode-json-languageservice";
import { TextDocument } from "vscode-languageserver-textdocument";
import { CodeLens, CompletionItem, Diagnostic, Position, Range } from "vscode-languageserver-types";
import { CodeCompletionStrategy } from "./types";
export declare type DashbuilderLanguageServiceArgs = EditorLanguageServiceArgs;
export declare class DashbuilderLanguageService implements IEditorLanguageService {
    private readonly args;
    private readonly els;
    constructor(args: DashbuilderLanguageServiceArgs);
    getCompletionItems(args: {
        content: string;
        uri: string;
        cursorPosition: Position;
        cursorWordRange: Range;
        rootNode: ELsNode | undefined;
        codeCompletionStrategy: CodeCompletionStrategy;
    }): Promise<CompletionItem[]>;
    getCodeLenses(args: {
        content: string;
        uri: string;
        rootNode: ELsNode | undefined;
        codeCompletionStrategy: CodeCompletionStrategy;
    }): Promise<CodeLens[]>;
    getDiagnostics(args: {
        content: string;
        uriPath: string;
        rootNode: ELsNode | undefined;
        getSchemaDiagnostics: (args: {
            textDocument: TextDocument;
            fileMatch: string[];
        }) => Promise<Diagnostic[]>;
    }): Promise<Diagnostic[]>;
    getSchemaDiagnostics(args: {
        textDocument: TextDocument;
        fileMatch: string[];
        jsonSchema: JSONSchema;
    }): Promise<Diagnostic[]>;
    dispose(): void;
}
//# sourceMappingURL=DashbuilderLanguageService.d.ts.map