"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scorecardFactory = exports.SCORE_CARD = void 0;
var pmml4_4_1 = require("../../model/pmml4_4");
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelExplanation_1 = require("./ModelExplanation");
var ModelStats_1 = require("./ModelStats");
var ModelVerification_1 = require("./ModelVerification");
var Output_1 = require("./Output");
var Targets_1 = require("./Targets");
var COMPLEX_PARTIAL_SCORE = "\n  \"ComplexPartialScore\": $v.elements[(name = \"ComplexPartialScore\")] ~> $map(function($v, $i) {\n    $v\n})";
var ATTRIBUTE = "\n{\n  \"Attribute\": [$v.elements[(name = \"Attribute\")] ~> $map(function($v, $i) {\n    $merge([\n      $v.attributes,\n      {\n        \"partialScore\": $number($v.attributes.partialScore),\n        \"predicate\": $json2uiPredicateFactory($v.elements[0]),\n        ".concat(COMPLEX_PARTIAL_SCORE, "        \n      }\n    ])\n  })]\n}");
var CHARACTERISTICS = "\n\"Characteristics\": {\n  \"Characteristic\": [$v.elements[(name = \"Characteristics\")].elements[(name = \"Characteristic\")] ~> $map(function($v, $i) {\n    $merge([\n      $v.attributes,\n      {\n        \"baselineScore\": $number($v.attributes.baselineScore)\n      },\n      ".concat(ATTRIBUTE, "\n    ])\n  })]\n}");
exports.SCORE_CARD = "\nelements.elements[(name = \"Scorecard\")] ~> $map(function($v, $i) {\n  $merge([\n    $scorecardFactory(),\n    $v.attributes,\n    {\n      \"isScorable\": $eval($v.attributes.isScorable),\n      \"useReasonCodes\": $eval($v.attributes.useReasonCodes),\n      \"initialScore\": $number($v.attributes.initialScore),\n      \"baselineScore\": $number($v.attributes.baselineScore),\n      \"_type\": $v.name\n    },\n    {\n      ".concat(MiningSchema_1.MINING_SCHEMA, ", \n      ").concat(Output_1.OUTPUT, ",\n      ").concat(CHARACTERISTICS, ", \n      ").concat(ModelStats_1.MODEL_STATS, ",\n      ").concat(ModelExplanation_1.MODEL_EXPLANATION, ",\n      ").concat(ModelVerification_1.MODEL_VERIFICATION, ",\n      ").concat(Targets_1.TARGETS, ",\n      ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, "\n    }\n  ])\n})");
function scorecardFactory() {
    return new pmml4_4_1.Scorecard({
        MiningSchema: new pmml4_4_1.MiningSchema({ MiningField: [] }),
        Characteristics: new pmml4_4_1.Characteristics({ Characteristic: [] }),
        functionName: "regression",
    });
}
exports.scorecardFactory = scorecardFactory;
//# sourceMappingURL=Scorecard.js.map