import React from "react";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import Moment from "react-moment";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const JobsDetailsModal = ({ actionType, modalTitle, isModalOpen, modalAction, handleModalToggle, job, ouiaId, ouiaSafe, }) => {
    const modalContent = () => {
        return (React.createElement("div", { className: "kogito-management-console-shared--jobsModal__detailsModal" },
            React.createElement(TextContent, null,
                React.createElement(Flex, { direction: { default: "column" } },
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "Workflow Id: "),
                                " "),
                            React.createElement(SplitItem, null, job.workflowId))),
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                " ",
                                React.createElement(Text, { component: TextVariants.h6 }, "Workflow Instance Id: "),
                                " "),
                            React.createElement(SplitItem, null, job.workflowInstanceId))),
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "Status: "),
                                " "),
                            React.createElement(SplitItem, null, job.status))),
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "Priority: "),
                                " "),
                            React.createElement(SplitItem, null, job.priority))),
                    job.repeatInterval && (React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "RepeatInterval: ")),
                            React.createElement(SplitItem, null, job.repeatInterval)))),
                    job.repeatLimit && (React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "RepeatLimit: ")),
                            React.createElement(SplitItem, null, job.repeatLimit)))),
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "ScheduledId: ")),
                            React.createElement(SplitItem, null, job.scheduledId))),
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "Retries: ")),
                            React.createElement(SplitItem, null, job.retries))),
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "Execution counter: ")),
                            React.createElement(SplitItem, null, job.executionCounter))),
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6 }, "Last Updated: ")),
                            React.createElement(SplitItem, null,
                                React.createElement(Moment, { fromNow: true }, new Date(`${job.lastUpdate}`))))),
                    React.createElement(FlexItem, null,
                        React.createElement(Split, { hasGutter: true },
                            React.createElement(SplitItem, null,
                                React.createElement(Text, { component: TextVariants.h6, className: "kogito-management-console-shared--jobsModal__text" },
                                    "Callback Endpoint:",
                                    " ")),
                            React.createElement(SplitItem, null, job.callbackEndpoint)))))));
    };
    return (React.createElement(Modal, Object.assign({ variant: "large", "aria-labelledby": actionType + "modal", "aria-label": actionType + "modal", title: "", header: modalTitle, isOpen: isModalOpen, onClose: handleModalToggle, actions: modalAction }, componentOuiaProps(ouiaId, "job-details-modal", ouiaSafe)), modalContent()));
};
//# sourceMappingURL=JobsDetailsModal.js.map