import React, { useState } from "react";
import { ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, Toolbar, ToolbarContent, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import remove from "lodash/remove";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
var Category;
(function (Category) {
    Category["PROCESS_NAME"] = "Workflow name";
})(Category || (Category = {}));
const WorkflowDefinitionListToolbar = ({ applyFilter, filterWorkflowNames, setFilterWorkflowNames, onOpenTriggerCloudEvent, ouiaSafe, ouiaId, }) => {
    const [workflowNameInput, setWorkflowNameInput] = useState("");
    const doResetFilter = () => {
        applyFilter();
        setFilterWorkflowNames([]);
    };
    const doRefresh = () => {
        setFilterWorkflowNames([...filterWorkflowNames]);
        applyFilter();
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            workflowNameInput.length > 0 && doApplyFilter();
        }
    };
    const onDeleteFilterGroup = (categoryName, value) => {
        const newfilterWorkflowNames = [...filterWorkflowNames];
        if (categoryName === Category.PROCESS_NAME) {
            remove(newfilterWorkflowNames, (status) => {
                return status === value;
            });
            setFilterWorkflowNames(newfilterWorkflowNames);
            applyFilter();
        }
    };
    const doApplyFilter = () => {
        const newWorkflowNames = [...filterWorkflowNames];
        if (workflowNameInput && !newWorkflowNames.includes(workflowNameInput)) {
            newWorkflowNames.push(workflowNameInput);
            setFilterWorkflowNames(newWorkflowNames);
        }
        setWorkflowNameInput("");
        applyFilter();
    };
    const toggleGroupItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarGroup, { variant: "filter-group" },
            React.createElement(ToolbarFilter, { key: "input-workflow-name", chips: filterWorkflowNames, deleteChip: onDeleteFilterGroup, categoryName: Category.PROCESS_NAME },
                React.createElement(InputGroup, null,
                    React.createElement(TextInput, { name: "workflowName", id: "workflowName", type: "search", "aria-label": "workflow name", onChange: setWorkflowNameInput, onKeyPress: onEnterClicked, placeholder: `Filter by workflow name`, value: workflowNameInput }))),
            React.createElement(ToolbarItem, null,
                React.createElement(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter, "data-testid": "apply-filter" }, "Apply Filter")))));
    const toolbarItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarToggleGroup, { toggleIcon: React.createElement(FilterIcon, null), breakpoint: "xl" }, toggleGroupItems),
        React.createElement(ToolbarGroup, { variant: "icon-button-group" },
            React.createElement(ToolbarItem, null,
                React.createElement(Tooltip, { content: "Refresh" },
                    React.createElement(Button, { variant: "plain", onClick: doRefresh, id: "refresh", "data-testid": "refresh" },
                        React.createElement(SyncIcon, null))))),
        onOpenTriggerCloudEvent && (React.createElement(ToolbarGroup, null,
            React.createElement(ToolbarItem, { variant: "separator" }),
            React.createElement(ToolbarItem, null,
                React.createElement(Button, { variant: "primary", key: "triggerCloudEventButton", onClick: () => onOpenTriggerCloudEvent() }, "Trigger Cloud Event"))))));
    return (React.createElement(Toolbar, Object.assign({ id: "workflow-definition-list-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default" }, componentOuiaProps(ouiaId, "workflow-definition-list-toolbar", ouiaSafe)),
        React.createElement(ToolbarContent, null, toolbarItems)));
};
export default WorkflowDefinitionListToolbar;
//# sourceMappingURL=WorkflowDefinitionListToolbar.js.map