import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { EmbeddedWorkflowFormChannelApiImpl } from "./EmbeddedWorkflowFormChannelApiImpl";
import { init } from "../envelope";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
export const EmbeddedWorkflowForm = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.workflowForm__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, Object.assign({}, props.workflowDefinition));
    }, []);
    return (React.createElement(EmbeddedWorkflowFormEnvelope, { ref: forwardedRef, apiImpl: new EmbeddedWorkflowFormChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedWorkflowFormEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedWorkflowForm.js.map