import React, { useEffect, useImperativeHandle, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { PencilAltIcon } from "@patternfly/react-icons/dist/js/icons/pencil-alt-icon";
import { CheckIcon } from "@patternfly/react-icons/dist/js/icons/check-icon";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { componentOuiaProps } from "../../ouiaTools";
export const InlineEdit = React.forwardRef(({ setBusinessKey, getBusinessKey, ouiaId, ouiaSafe }, forwardedRef) => {
    const [isEditable, setIsEditable] = useState(false);
    const [inputValue, setInputValue] = useState("");
    const [currentBusinessKey, setCurrentBusinessKey] = useState(getBusinessKey());
    useEffect(() => {
        if (currentBusinessKey.length === 0) {
            setInputValue("");
        }
    }, [currentBusinessKey]);
    const toggleEditableMode = () => {
        setIsEditable(!isEditable);
    };
    const confirmBusinessKey = (isConfirmed) => {
        if (isConfirmed) {
            setBusinessKey(inputValue);
            setCurrentBusinessKey(inputValue);
        }
        toggleEditableMode();
    };
    useImperativeHandle(forwardedRef, () => ({
        reset: () => {
            setInputValue("");
            setCurrentBusinessKey("");
        },
    }), []);
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "inline-edit", ouiaSafe), { className: `pf-c-inline-edit ${isEditable && "pf-m-inline-editable"}`, id: "inline-edit-toggle-example" }),
        React.createElement("div", { className: "pf-c-inline-edit__group" },
            React.createElement("div", { className: "pf-c-inline-edit__value", id: "single-editable-example-label" }, currentBusinessKey.length > 0 ? (currentBusinessKey) : (React.createElement("span", { className: "pf-u-disabled-color-100" }, "Business key"))),
            React.createElement("div", { className: "pf-c-inline-edit__action pf-m-enable-editable" },
                React.createElement(Button, { variant: "plain", onClick: toggleEditableMode },
                    React.createElement(PencilAltIcon, null)))),
        React.createElement("div", { className: "pf-c-inline-edit__group" },
            React.createElement("div", { className: "pf-c-inline-edit__input" },
                React.createElement(TextInput, { value: inputValue, type: "text", placeholder: "Enter business key", onChange: setInputValue, "aria-label": "text input example" })),
            React.createElement("div", { className: "pf-c-inline-edit__group pf-m-action-group pf-m-icon-group" },
                React.createElement("div", { className: "pf-c-inline-edit__action pf-m-valid" },
                    React.createElement(Button, { variant: "plain", onClick: () => confirmBusinessKey(true) },
                        React.createElement(CheckIcon, null))),
                React.createElement("div", { className: "pf-c-inline-edit__action" },
                    React.createElement(Button, { variant: "plain", onClick: () => confirmBusinessKey(false) },
                        React.createElement(TimesIcon, null)))))));
});
export default InlineEdit;
//# sourceMappingURL=InlineEdit.js.map