import React from "react";
import { EmptyState, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Spinner } from "@patternfly/react-core/dist/js/components/Spinner";
import { componentOuiaProps } from "../../ouiaTools";
export const KogitoSpinner = ({ spinnerText, ouiaId, ouiaSafe }) => {
    return (React.createElement(EmptyState, Object.assign({}, componentOuiaProps(ouiaId, "kogito-spinner", ouiaSafe)),
        React.createElement(EmptyStateIcon, { variant: "container", component: Spinner }),
        React.createElement(Title, { size: "lg", headingLevel: "h3" }, spinnerText)));
};
//# sourceMappingURL=KogitoSpinner.js.map