var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useState } from "react";
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { ClipboardCopy, ClipboardCopyVariant } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { componentOuiaProps } from "../../ouiaTools";
export const ServerErrors = (_a) => {
    var { ouiaId, ouiaSafe } = _a, props = __rest(_a, ["ouiaId", "ouiaSafe"]);
    const [displayError, setDisplayError] = useState(false);
    const getErrorSubTitle = () => {
        try {
            const errorObject = JSON.parse(props.error);
            if ((errorObject.networkError && errorObject.networkError.name) ||
                (errorObject.networkError &&
                    !errorObject.networkError.name &&
                    errorObject.graphQLErrors &&
                    !(errorObject.graphQLErrors.size > 0) &&
                    errorObject.message === "Network error: Failed to fetch")) {
                return "An error occurred while accessing data. It is possible the data index is still being loaded, please try again in a few moments.";
            }
            else {
                return "An error occurred while accessing data.";
            }
        }
        catch (error) {
            return "An error occurred while accessing data.";
        }
    };
    const getErrorContent = () => {
        try {
            const errorObject = typeof props.error === "string" ? JSON.parse(props.error) : props.error;
            return errorObject.networkError && errorObject.networkError.name
                ? JSON.stringify(errorObject.networkError)
                : errorObject.graphQLErrors && errorObject.graphQLErrors.size > 0
                    ? JSON.stringify(errorObject.graphQLErrors)
                    : errorObject.message
                        ? errorObject.message
                        : JSON.stringify(props.error);
        }
        catch (error) {
            return props.error;
        }
    };
    const renderContent = () => (React.createElement(Bullseye, Object.assign({}, componentOuiaProps(ouiaId, "server-errors", ouiaSafe)),
        React.createElement(EmptyState, { variant: EmptyStateVariant.full },
            React.createElement(EmptyStateIcon, { icon: ExclamationCircleIcon, color: "var(--pf-global--danger-color--100)" }),
            React.createElement(Title, { headingLevel: "h1", size: "4xl" }, "Error fetching data"),
            React.createElement(EmptyStateBody, null,
                getErrorSubTitle(),
                " ",
                React.createElement(Button, { variant: "link", isInline: true, id: "display-error", onClick: () => setDisplayError(!displayError) }, "See more details")),
            displayError && (React.createElement(EmptyStateBody, null,
                React.createElement(ClipboardCopy, { isCode: true, variant: ClipboardCopyVariant.expansion, isExpanded: true, className: "pf-u-text-align-left" }, getErrorContent()))),
            props.children)));
    return (React.createElement(React.Fragment, null,
        props.variant === "large" && React.createElement(PageSection, { variant: "light" }, renderContent()),
        props.variant === "small" && renderContent()));
};
//# sourceMappingURL=ServerErrors.js.map