import React from "react";
import { TextContent, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { componentOuiaProps } from "../../ouiaTools";
import { BulkList } from "../BulkList";
export const WorkflowInfoModal = ({ modalContent, modalTitle, isModalOpen, handleModalToggle, resetSelected, operationResult, workflowName, ouiaId, ouiaSafe, }) => {
    const onOkClick = () => {
        handleModalToggle();
        operationResult && resetSelected && resetSelected();
    };
    const createBoldText = (text, shouldBeBold) => {
        if (text && shouldBeBold && shouldBeBold.length > 0) {
            const textArray = text.split(shouldBeBold);
            return (React.createElement("span", null, textArray.map((item, index) => (React.createElement(React.Fragment, { key: index },
                item,
                index !== textArray.length - 1 && React.createElement("b", null, shouldBeBold))))));
        }
        else {
            return React.createElement("span", null, text);
        }
    };
    return (React.createElement(Modal, Object.assign({ variant: "small", title: "", header: modalTitle, isOpen: isModalOpen, onClose: onOkClick, "aria-label": "workflow list modal", "aria-labelledby": "workflow list modal", actions: [
            React.createElement(Button, { key: "confirm-selection", variant: "primary", onClick: onOkClick }, "OK"),
        ] }, componentOuiaProps(ouiaId, "workflow-list-modal", ouiaSafe)),
        operationResult !== undefined && React.createElement(BulkList, { operationResult: operationResult }),
        React.createElement(TextContent, null,
            React.createElement(Text, null, createBoldText(modalContent, workflowName)))));
};
//# sourceMappingURL=WorkflowInfoModal.js.map