import React from "react";
import { BanIcon } from "@patternfly/react-icons/dist/js/icons/ban-icon";
import { OnRunningIcon } from "@patternfly/react-icons/dist/js/icons/on-running-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { PausedIcon } from "@patternfly/react-icons/dist/js/icons/paused-icon";
import { ErrorCircleOIcon } from "@patternfly/react-icons/dist/js/icons/error-circle-o-icon";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export const ProcessInstanceIconCreator = (state) => {
    switch (state) {
        case ProcessInstanceState.Active:
            return (React.createElement(React.Fragment, null,
                React.createElement(OnRunningIcon, { className: "pf-u-mr-sm" }),
                "Active"));
        case ProcessInstanceState.Completed:
            return (React.createElement(React.Fragment, null,
                React.createElement(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" }),
                "Completed"));
        case ProcessInstanceState.Aborted:
            return (React.createElement(React.Fragment, null,
                React.createElement(BanIcon, { className: "pf-u-mr-sm" }),
                "Aborted"));
        case ProcessInstanceState.Suspended:
            return (React.createElement(React.Fragment, null,
                React.createElement(PausedIcon, { className: "pf-u-mr-sm" }),
                "Suspended"));
        case ProcessInstanceState.Error:
            return (React.createElement(React.Fragment, null,
                React.createElement(ErrorCircleOIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }),
                "Error"));
    }
};
export const getProcessInstanceDescription = (processInstance) => {
    return {
        id: processInstance.id,
        name: processInstance.processName,
        description: processInstance.businessKey,
    };
};
export const alterOrderByObj = (orderByObj) => {
    if (orderByObj["id"]) {
        orderByObj["processName"] = orderByObj["id"];
        delete orderByObj["id"];
    }
    else if (orderByObj["status"]) {
        orderByObj["state"] = orderByObj["status"];
        delete orderByObj["status"];
    }
    else if (orderByObj["created"]) {
        orderByObj["start"] = orderByObj["created"];
        delete orderByObj["created"];
    }
    return orderByObj;
};
export const checkProcessInstanceState = (processInstance) => {
    var _a;
    if ((processInstance.state === ProcessInstanceState.Error ||
        processInstance.state === ProcessInstanceState.Active ||
        processInstance.state === ProcessInstanceState.Suspended) &&
        ((_a = processInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) &&
        processInstance.serviceUrl) {
        return false;
    }
    else {
        return true;
    }
};
export const formatForBulkListProcessInstance = (processInstanceList) => {
    const formattedItems = [];
    processInstanceList.forEach((item) => {
        const formattedObj = {
            id: item.id,
            description: item.businessKey,
            name: item.processName,
            errorMessage: item.errorMessage ? item.errorMessage : undefined,
        };
        formattedItems.push(formattedObj);
    });
    return formattedItems;
};
export const processListDefaultStatusFilter = [ProcessInstanceState.Active];
export const workflowListDefaultStatusFilter = [
    ProcessInstanceState.Aborted,
    ProcessInstanceState.Active,
    ProcessInstanceState.Completed,
    ProcessInstanceState.Error,
    ProcessInstanceState.Suspended,
];
//# sourceMappingURL=ProcessListUtils.js.map