var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as React from "react";
import * as ReactDOM from "react-dom";
import { Envelope } from "@kie-tools-core/envelope";
import { TaskFormEnvelopeView } from "./TaskFormEnvelopeView";
import { TaskFormEnvelopeApiImpl } from "./TaskFormEnvelopeApiImpl";
import "./styles.css";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = () => __awaiter(this, void 0, void 0, function* () {
        const ref = React.createRef();
        return new Promise((res) => {
            args.container.className = "kogito-task-form-container";
            ReactDOM.render(React.createElement(TaskFormEnvelopeView, { ref: ref, channelApi: envelope.channelApi, targetOrigin: args.targetOrigin }), args.container, () => res(() => ref.current));
        });
    });
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => new TaskFormEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=TaskFormEnvelope.js.map