import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { TaskInboxChannelApiImpl } from "./TaskInboxChannelApiImpl";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
export const EmbeddedTaskInbox = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({
        taskInbox__notify: (userName) => envelopeServer.envelopeApi.requests.taskInbox__notify(userName),
    }), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.taskInbox__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            initialState: props.initialState,
            allTaskStates: props.allTaskStates,
            activeTaskStates: props.activeTaskStates,
        });
    }, [props.allTaskStates, props.activeTaskStates]);
    return (React.createElement(EmbeddedTaskInboxEnvelope, { ref: forwardedRef, apiImpl: new TaskInboxChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedTaskInboxEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedTaskInbox.js.map