/// <reference types="react" />
import { FormI18n } from "./i18n";
export declare enum FormStatus {
    WITHOUT_ERROR = 0,
    VALIDATOR_ERROR = 1,
    AUTO_GENERATION_ERROR = 2,
    EMPTY = 3
}
interface CommonFormStatusProps {
    i18n: FormI18n;
}
interface EmptyFormStatusProps extends CommonFormStatusProps {
}
export declare function EmptyFormStatus({ i18n }: EmptyFormStatusProps): JSX.Element;
interface AutoGenerationErrorWithNotificationFormStatusProps extends CommonFormStatusProps {
    notificationsPanel: true;
    openValidationTab: () => void;
}
interface AutoGenerationErrorWithoutNotificationFormStatusProps extends CommonFormStatusProps {
    notificationsPanel: false;
}
declare type AutoGenerationErrorFormStatusProps = AutoGenerationErrorWithNotificationFormStatusProps | AutoGenerationErrorWithoutNotificationFormStatusProps;
export declare function AutoGenerationErrorFormStatus(props: AutoGenerationErrorFormStatusProps): JSX.Element;
interface ValidatorErrorFormStatusProps extends CommonFormStatusProps {
}
export declare function ValidatorErrorFormStatus({ i18n }: ValidatorErrorFormStatusProps): JSX.Element;
export {};
//# sourceMappingURL=FormStatus.d.ts.map