import { de as de_common } from "@kie-tools/i18n-common-dictionary";
import { wrapped } from "@kie-tools-core/i18n/dist/core";
export const de = Object.assign(Object.assign({}, de_common), { form: {
        status: {
            autoGenerationError: {
                title: `${de_common.terms.oops}!`,
                explanation: "Das Formular kann aufgrund eines Fehlers nicht dargestellt werden.",
                checkNotificationPanel: ["Auf ", wrapped("link"), ` Fehler im Benachrichtigungsfeld prüfen`],
            },
            emptyForm: {
                title: "Kein Formular",
                explanation: `Ohne Eingänge.`,
            },
            validatorError: {
                title: "Beim Versuch, das Formular zu erstellen, ist ein Fehler aufgetreten",
                message: [
                    `Das JSON-Schema enthält ein Konstrukt, das noch nicht unterstützt wird. Bitte beachten Sie `,
                    wrapped("jira"),
                    " und melden Sie ein Problem. Vergessen Sie nicht, die aktuelle Datei hochzuladen.",
                ],
            },
        },
    }, schema: {
        selectPlaceholder: "Auswählen...",
    } });
//# sourceMappingURL=de.js.map