import { en as en_common } from "@kie-tools/i18n-common-dictionary";
import { wrapped } from "@kie-tools-core/i18n/dist/core";
export const en = Object.assign(Object.assign({}, en_common), { form: {
        status: {
            autoGenerationError: {
                title: `${en_common.terms.oops}!`,
                explanation: "Form cannot be rendered because of an error.",
                checkNotificationPanel: ["Check for ", wrapped("link"), ` error on the Notifications Panel`],
            },
            emptyForm: {
                title: "No Form",
                explanation: `Without inputs.`,
            },
            validatorError: {
                title: "An error occurred while trying to generate the form",
                message: [
                    `The JSON schema contains a construct that is not yet supported. Please refer to `,
                    wrapped("jira"),
                    " and report an issue. Don't forget to upload the current file.",
                ],
            },
        },
    }, schema: {
        selectPlaceholder: "Select...",
    } });
//# sourceMappingURL=en.js.map