"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUseReasonCodes = exports.getBaselineScore = exports.getCharacteristics = exports.getOutputs = exports.getMiningField = exports.getMiningSchema = exports.getDataDictionary = exports.findIncrementalName = exports.isSupportedModelType = exports.getModelIconUrlByType = exports.getModelType = exports.getModelName = exports.isCollection = exports.PMMLModels = exports.SupportedCapability = void 0;
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var paths_1 = require("./paths");
var lodash_1 = require("lodash");
var ICON_BASE = "images/";
var ICON_DEFAULT = "card-icon-default.svg";
var SupportedCapability;
(function (SupportedCapability) {
    SupportedCapability[SupportedCapability["NONE"] = 0] = "NONE";
    SupportedCapability[SupportedCapability["VIEWER"] = 1] = "VIEWER";
    SupportedCapability[SupportedCapability["EDITOR"] = 2] = "EDITOR";
})(SupportedCapability = exports.SupportedCapability || (exports.SupportedCapability = {}));
exports.PMMLModels = new Array({
    model: pmml_editor_marshaller_1.AnomalyDetectionModel,
    type: "Anomaly Detection Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.AssociationModel,
    type: "Association Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.BayesianNetworkModel,
    type: "Bayesian Network Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.BaselineModel,
    type: "Baseline Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.ClusteringModel,
    type: "Clustering Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.GaussianProcessModel,
    type: "Gaussian Process Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.GeneralRegressionModel,
    type: "General Regression Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.MiningModel,
    type: "Mining Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.NaiveBayesModel,
    type: "Naive Bayes Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.NearestNeighborModel,
    type: "Nearest Neighbor Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.NeuralNetwork,
    type: "Neural Network",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.RegressionModel,
    type: "Regression Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.VIEWER,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.RuleSetModel,
    type: "RuleSet Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.SequenceModel,
    type: "Sequence Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.Scorecard,
    type: "Scorecard",
    iconUrl: "card-icon-scorecard.svg",
    capability: SupportedCapability.EDITOR,
    factory: function () {
        var model = new pmml_editor_marshaller_1.Scorecard({
            modelName: "Untitled model",
            MiningSchema: { MiningField: [] },
            Characteristics: { Characteristic: [] },
            Output: { OutputField: [] },
            functionName: "regression",
        });
        model._type = "Scorecard";
        return model;
    },
}, {
    model: pmml_editor_marshaller_1.SupportVectorMachineModel,
    type: "Support Vector Machine Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.TextModel,
    type: "Text Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.TimeSeriesModel,
    type: "Time Series Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
}, {
    model: pmml_editor_marshaller_1.TreeModel,
    type: "Tree Model",
    iconUrl: "card-icon-default.svg",
    capability: SupportedCapability.NONE,
    factory: undefined,
});
var isCollection = function (collection) {
    if (collection === undefined) {
        return false;
    }
    return collection.length !== 0;
};
exports.isCollection = isCollection;
var getModelName = function (model) {
    var _a;
    return (_a = (0, lodash_1.get)(model, "modelName")) !== null && _a !== void 0 ? _a : "";
};
exports.getModelName = getModelName;
var getModelType = function (model) {
    var e_1, _a;
    try {
        for (var PMMLModels_1 = __values(exports.PMMLModels), PMMLModels_1_1 = PMMLModels_1.next(); !PMMLModels_1_1.done; PMMLModels_1_1 = PMMLModels_1.next()) {
            var _mapping = PMMLModels_1_1.value;
            if (model instanceof _mapping.model) {
                return _mapping.type;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (PMMLModels_1_1 && !PMMLModels_1_1.done && (_a = PMMLModels_1.return)) _a.call(PMMLModels_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
};
exports.getModelType = getModelType;
var getModelIconUrlByType = function (type) {
    var e_2, _a;
    try {
        for (var PMMLModels_2 = __values(exports.PMMLModels), PMMLModels_2_1 = PMMLModels_2.next(); !PMMLModels_2_1.done; PMMLModels_2_1 = PMMLModels_2.next()) {
            var _mapping = PMMLModels_2_1.value;
            if (type === _mapping.type) {
                return ICON_BASE + _mapping.iconUrl;
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (PMMLModels_2_1 && !PMMLModels_2_1.done && (_a = PMMLModels_2.return)) _a.call(PMMLModels_2);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return ICON_BASE + ICON_DEFAULT;
};
exports.getModelIconUrlByType = getModelIconUrlByType;
var isSupportedModelType = function (model) {
    var e_3, _a;
    try {
        for (var PMMLModels_3 = __values(exports.PMMLModels), PMMLModels_3_1 = PMMLModels_3.next(); !PMMLModels_3_1.done; PMMLModels_3_1 = PMMLModels_3.next()) {
            var _mapping = PMMLModels_3_1.value;
            if (model instanceof _mapping.model) {
                return _mapping.capability === SupportedCapability.VIEWER || _mapping.capability === SupportedCapability.EDITOR;
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (PMMLModels_3_1 && !PMMLModels_3_1.done && (_a = PMMLModels_3.return)) _a.call(PMMLModels_3);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return false;
};
exports.isSupportedModelType = isSupportedModelType;
var findIncrementalName = function (name, existingNames, startsFrom) {
    var newName = "";
    var counter = startsFrom;
    var _loop_1 = function () {
        var potentialName = "".concat(name).concat(counter !== 1 ? " ".concat(counter) : "");
        var found = existingNames.filter(function (existingName) { return existingName === potentialName; });
        if (found.length === 0) {
            newName = potentialName;
        }
        counter++;
    };
    do {
        _loop_1();
    } while (newName.length === 0);
    return newName;
};
exports.findIncrementalName = findIncrementalName;
var getDataDictionary = function (pmml) {
    return (0, lodash_1.get)(pmml, (0, paths_1.Builder)().forDataDictionary().build().path);
};
exports.getDataDictionary = getDataDictionary;
var getMiningSchema = function (pmml, modelIndex) {
    return (0, lodash_1.get)(pmml, (0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().build().path);
};
exports.getMiningSchema = getMiningSchema;
var getMiningField = function (pmml, modelIndex, miningFieldIndex) {
    return (0, lodash_1.get)(pmml, (0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).build().path);
};
exports.getMiningField = getMiningField;
var getOutputs = function (pmml, modelIndex) {
    return (0, lodash_1.get)(pmml, (0, paths_1.Builder)().forModel(modelIndex).forOutput().build().path);
};
exports.getOutputs = getOutputs;
var getCharacteristics = function (pmml, modelIndex) {
    return (0, lodash_1.get)(pmml, (0, paths_1.Builder)().forModel(modelIndex).forCharacteristics().build().path);
};
exports.getCharacteristics = getCharacteristics;
var getBaselineScore = function (pmml, modelIndex) {
    return (0, lodash_1.get)(pmml, (0, paths_1.Builder)().forModel(modelIndex).forBaselineScore().build().path);
};
exports.getBaselineScore = getBaselineScore;
var getUseReasonCodes = function (pmml, modelIndex) {
    return (0, lodash_1.get)(pmml, (0, paths_1.Builder)().forModel(modelIndex).forUseReasonCodes().build().path);
};
exports.getUseReasonCodes = getUseReasonCodes;
//# sourceMappingURL=PMMLModelHelper.js.map