"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var react_redux_1 = require("react-redux");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Modal_1 = require("@patternfly/react-core/dist/js/components/Modal");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var close_icon_1 = require("@patternfly/react-icons/dist/js/icons/close-icon");
var warning_triangle_icon_1 = require("@patternfly/react-icons/dist/js/icons/warning-triangle-icon");
var reducers_1 = require("../../../reducers");
var DataDictionaryContainer_1 = require("../DataDictionaryContainer/DataDictionaryContainer");
var dataDictionaryUtils_1 = require("../dataDictionaryUtils");
var EditorScorecard_1 = require("../../EditorScorecard");
var history_1 = require("../../../history");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var atoms_1 = require("../../EditorCore/atoms");
var DataDictionaryHandler = function () {
    var _a = __read((0, react_1.useState)(false), 2), isDataDictionaryOpen = _a[0], setIsDataDictionaryOpen = _a[1];
    var pmmlDataDictionary = (0, react_redux_1.useSelector)(function (state) { return state.DataDictionary; });
    var dictionary = (0, react_1.useMemo)(function () { return (0, dataDictionaryUtils_1.convertPMML2DD)(pmmlDataDictionary); }, [pmmlDataDictionary]);
    var setActiveOperation = (0, EditorScorecard_1.useOperation)().setActiveOperation;
    var _b = (0, history_1.useHistoryService)(), service = _b.service, getCurrentState = _b.getCurrentState;
    var dispatch = (0, history_1.useBatchDispatch)(service, getCurrentState);
    var handleDataDictionaryToggle = function () {
        setActiveOperation(EditorScorecard_1.Operation.NONE);
        setIsDataDictionaryOpen(!isDataDictionaryOpen);
    };
    var addField = function (name, type, optype) {
        dispatch({
            type: reducers_1.Actions.AddDataDictionaryField,
            payload: {
                name: name,
                type: type,
                optype: optype,
            },
        });
    };
    var addBatchFields = function (fields) {
        dispatch({
            type: reducers_1.Actions.AddBatchDataDictionaryFields,
            payload: {
                dataDictionaryFields: fields,
            },
        });
    };
    var deleteField = function (index) {
        dispatch({
            type: reducers_1.Actions.DeleteDataDictionaryField,
            payload: {
                index: index,
            },
        });
    };
    var reorderFields = function (oldIndex, newIndex) {
        dispatch({
            type: reducers_1.Actions.ReorderDataDictionaryFields,
            payload: {
                oldIndex: oldIndex,
                newIndex: newIndex,
            },
        });
    };
    var updateField = function (index, originalName, field) {
        dispatch({
            type: reducers_1.Actions.UpdateDataDictionaryField,
            payload: {
                dataDictionaryIndex: index,
                dataField: (0, dataDictionaryUtils_1.convertToDataField)(field),
                originalName: originalName,
            },
        });
    };
    var handleEditingPhase = function (status) {
        setActiveOperation(status ? EditorScorecard_1.Operation.UPDATE_DATA_DICTIONARY : EditorScorecard_1.Operation.NONE);
    };
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forDataDictionary().build()); }, [dictionary]);
    var header = ((0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ headingLevel: "h1", size: Title_1.TitleSizes["2xl"] }, { children: "Data Dictionary" })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ type: "button", variant: Button_1.ButtonVariant.plain, onClick: handleDataDictionaryToggle, "data-title": "DataDictionaryModalClose" }, { children: (0, jsx_runtime_1.jsx)(close_icon_1.CloseIcon, {}) })) })] })));
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validations.length === 0 && ((0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", onClick: handleDataDictionaryToggle, "data-title": "DataDictionary" }, { children: "Set Data Dictionary" }))), validations.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorTooltip, __assign({ validations: validations }, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", icon: (0, jsx_runtime_1.jsx)(warning_triangle_icon_1.WarningTriangleIcon, { size: "sm", color: "orange" }), onClick: handleDataDictionaryToggle, "data-title": "DataDictionary" }, { children: "Set Data Dictionary" })) }))), (0, jsx_runtime_1.jsx)(Modal_1.Modal, __assign({ "aria-label": "data-dictionary", title: "Data Dictionary", header: header, isOpen: isDataDictionaryOpen, showClose: false, variant: Modal_1.ModalVariant.large, onEscapePress: function () { return false; }, "data-title": "DataDictionaryModal" }, { children: (0, jsx_runtime_1.jsx)(DataDictionaryContainer_1.default, { dataDictionary: dictionary, onAdd: addField, onEdit: updateField, onDelete: deleteField, onReorder: reorderFields, onBatchAdd: addBatchFields, onEditingPhaseChange: handleEditingPhase }) }))] }));
};
exports.default = DataDictionaryHandler;
//# sourceMappingURL=DataDictionaryHandler.js.map