"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var react_cool_onclickoutside_1 = require("react-cool-onclickoutside");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Select_1 = require("@patternfly/react-core/dist/js/components/Select");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var trash_icon_1 = require("@patternfly/react-icons/dist/js/icons/trash-icon");
var arrow_alt_circle_right_icon_1 = require("@patternfly/react-icons/dist/js/icons/arrow-alt-circle-right-icon");
var exclamation_circle_icon_1 = require("@patternfly/react-icons/dist/js/icons/exclamation-circle-icon");
require("./DataTypeItem.scss");
var ConstraintsLabel_1 = require("../ConstraintsLabel/ConstraintsLabel");
var PropertiesLabels_1 = require("../PropertiesLabels/PropertiesLabels");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var atoms_1 = require("../../EditorCore/atoms");
var DataTypeItem = function (props) {
    var dataType = props.dataType, index = props.index, editingIndex = props.editingIndex, onSave = props.onSave, onEdit = props.onEdit, onDelete = props.onDelete, onConstraintsEdit = props.onConstraintsEdit, onConstraintsSave = props.onConstraintsSave, onValidate = props.onValidate, onOutsideClick = props.onOutsideClick;
    var _a = __read((0, react_1.useState)(dataType.name), 2), name = _a[0], setName = _a[1];
    var _b = __read((0, react_1.useState)(dataType.type), 2), typeSelection = _b[0], setTypeSelection = _b[1];
    var _c = __read((0, react_1.useState)(false), 2), isTypeSelectOpen = _c[0], setIsTypeSelectOpen = _c[1];
    var typeOptions = [
        { value: "string" },
        { value: "integer" },
        { value: "float" },
        { value: "double" },
        { value: "boolean" },
    ];
    var _d = __read((0, react_1.useState)(dataType.optype), 2), optypeSelection = _d[0], setOptypeSelection = _d[1];
    var _e = __read((0, react_1.useState)(false), 2), isOptypeSelectOpen = _e[0], setIsOptypeSelectOpen = _e[1];
    var optypeOptions = [{ value: "categorical" }, { value: "ordinal" }, { value: "continuous" }];
    var _f = __read((0, react_1.useState)("default"), 2), validation = _f[0], setValidation = _f[1];
    var ref = (0, react_cool_onclickoutside_1.default)(function () {
        onOutsideClick();
    }, { eventTypes: ["click"], disabled: editingIndex !== index });
    var handleNameChange = function (value) {
        setName(value);
        setValidation(onValidate(value) ? "default" : "error");
    };
    var typeToggle = function (isOpen) {
        setIsTypeSelectOpen(isOpen);
    };
    var typeSelect = function (event, value) {
        if (value !== typeSelection) {
            setTypeSelection(value);
            setIsTypeSelectOpen(false);
            onSave(__assign(__assign({}, dataType), { type: value }), index);
        }
    };
    var optypeToggle = function (isOpen) {
        setIsOptypeSelectOpen(isOpen);
    };
    var optypeSelect = function (event, value) {
        if (value !== optypeSelection) {
            setOptypeSelection(value);
            setIsOptypeSelectOpen(false);
            onSave(__assign(__assign({}, dataType), { optype: value }), index);
        }
    };
    var handleEditStatus = function (event) {
        event.preventDefault();
        event.stopPropagation();
        onEdit === null || onEdit === void 0 ? void 0 : onEdit(index);
    };
    var handleSave = function (event) {
        event === null || event === void 0 ? void 0 : event.preventDefault();
        onSave({ name: name.trim(), type: typeSelection, optype: optypeSelection }, index);
    };
    var handleNameSave = function () {
        if (validation === "error") {
            setName(dataType.name);
            setValidation("default");
        }
        else if (name !== dataType.name) {
            handleSave();
        }
    };
    var handleDelete = function (event, interaction) {
        event.stopPropagation();
        event.preventDefault();
        if (onDelete) {
            onDelete(index, interaction);
        }
    };
    var handleConstraints = function () {
        onConstraintsEdit(__assign(__assign({}, dataType), { name: name, type: typeSelection }));
    };
    var handleConstraintsDelete = function () {
        var updatedDataType = __assign({}, dataType);
        delete updatedDataType.constraints;
        onConstraintsSave(updatedDataType);
    };
    var handlePropertiesDelete = function (updatedDataType, updateIndex) {
        onSave(updatedDataType, updateIndex);
    };
    (0, react_1.useEffect)(function () {
        if (editingIndex === index) {
            var input = document.querySelector(".data-type-item-n".concat(index, " #name"));
            input === null || input === void 0 ? void 0 : input.focus();
            if (name.startsWith("New Data Type")) {
                input === null || input === void 0 ? void 0 : input.select();
            }
        }
        else {
            if (validation !== "success") {
                setName(dataType.name);
                setValidation("default");
            }
        }
    }, [editingIndex]);
    (0, react_1.useEffect)(function () {
        setName(dataType.name);
        setTypeSelection(dataType.type);
        setOptypeSelection(dataType.optype);
    }, [dataType]);
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forDataDictionary().forDataField(index).build()); }, [index, dataType]);
    return ((0, jsx_runtime_1.jsxs)("article", __assign({ id: "data-type-item-n".concat(index), "data-testid": "data-type-item-n".concat(index), className: "editable-item ".concat(editingIndex === index ? "editable-item--editing" : "", " data-type-item-n").concat(index), "data-ouia-component-id": name, "data-ouia-component-type": "dd-type-item", tabIndex: 0 }, { children: [editingIndex === index && ((0, jsx_runtime_1.jsx)("section", __assign({ className: "editable-item__inner", ref: ref, onKeyDown: function (event) {
                    if (event.key === "Escape") {
                        onOutsideClick();
                    }
                } }, { children: (0, jsx_runtime_1.jsx)(Form_1.Form, __assign({ onSubmit: function (e) {
                        e.stopPropagation();
                        e.preventDefault();
                    } }, { children: (0, jsx_runtime_1.jsx)(Split_1.Split, __assign({ hasGutter: true }, { children: (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ fieldId: "name", label: "Name", helperTextInvalid: "Name is mandatory and must be unique", helperTextInvalidIcon: (0, jsx_runtime_1.jsx)(exclamation_circle_icon_1.ExclamationCircleIcon, {}), validated: validation, style: { width: 280 }, isRequired: true, "data-ouia-component-type": "field-name" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "name", name: "name", value: name, onChange: handleNameChange, placeholder: "Name", validated: validation, onBlur: handleNameSave, autoComplete: "off" }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ fieldId: "type", label: "Type", isRequired: true, "data-ouia-component-type": "field-type" }, { children: (0, jsx_runtime_1.jsx)(Select_1.Select, __assign({ id: "type", variant: Select_1.SelectVariant.single, "aria-label": "Select Input Type", onToggle: typeToggle, onSelect: typeSelect, selections: typeSelection, isOpen: isTypeSelectOpen, placeholder: "Type", className: "data-type-item__type-select", menuAppendTo: "parent" }, { children: typeOptions.map(function (option, optionIndex) { return ((0, jsx_runtime_1.jsx)(Select_1.SelectOption, { value: option.value, className: "ignore-onclickoutside data-type-item__type-select__option", "data-ouia-component-type": "select-option" }, optionIndex)); }) })) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ fieldId: "optype", label: "Op Type", isRequired: true, "data-ouia-component-type": "field-optype" }, { children: (0, jsx_runtime_1.jsx)(Select_1.Select, __assign({ id: "optype", variant: Select_1.SelectVariant.single, "aria-label": "Select Op Type", onToggle: optypeToggle, onSelect: optypeSelect, selections: optypeSelection, isOpen: isOptypeSelectOpen, placeholder: "Op Type", className: "data-type-item__type-select", menuAppendTo: "parent" }, { children: optypeOptions.map(function (option, optionIndex) { return ((0, jsx_runtime_1.jsx)(Select_1.SelectOption, { value: option.value, className: "ignore-onclickoutside data-type-item__type-select__option", "data-ouia-component-type": "select-option" }, optionIndex)); }) })) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: "\u00A0" }))] })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Split_1.Split, __assign({ hasGutter: true }, { children: (0, jsx_runtime_1.jsxs)(Split_1.SplitItem, { children: [(0, jsx_runtime_1.jsx)(PropertiesLabels_1.default, { dataType: dataType, editingIndex: editingIndex, onPropertyDelete: handlePropertiesDelete }), (0, jsx_runtime_1.jsx)(ConstraintsLabel_1.default, { dataType: dataType, dataTypeIndex: index, editMode: true, onConstraintsDelete: handleConstraintsDelete }), (0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ variant: "outline", color: "cyan", href: "#", icon: (0, jsx_runtime_1.jsx)(arrow_alt_circle_right_icon_1.ArrowAltCircleRightIcon, {}), onClick: function (event) {
                                                            event.preventDefault();
                                                            handleConstraints();
                                                        }, "data-ouia-component-id": "edit-props", "data-ouia-component-type": "link-label" }, { children: "Edit Properties" }))] }) })) })] })) }) })) })) }))), editingIndex !== index && ((0, jsx_runtime_1.jsx)("section", __assign({ className: "editable-item__inner", onClick: handleEditStatus, onKeyDown: function (event) {
                    if (event.key === "Enter") {
                        handleEditStatus(event);
                    }
                } }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [validations.length > 0 && ((0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Flex_1.Flex, __assign({ alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentCenter" }, style: { height: "100%" } }, { children: (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicator, { validations: validations }) }) })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)("span", __assign({ className: "data-type-item__name" }, { children: name })) }), (0, jsx_runtime_1.jsxs)(Split_1.SplitItem, __assign({ isFilled: true }, { children: [(0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ color: "blue", className: "data-type-item__type-label", "data-ouia-component-id": typeSelection, "data-ouia-component-type": "data-type-label" }, { children: typeSelection })), " ", (0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ color: "blue", className: "data-type-item__type-label", "data-ouia-component-id": optypeSelection, "data-ouia-component-type": "data-optype-label" }, { children: optypeSelection })), " ", (0, jsx_runtime_1.jsx)(PropertiesLabels_1.default, { dataType: dataType }), (0, jsx_runtime_1.jsx)(ConstraintsLabel_1.default, { dataType: dataType, dataTypeIndex: index })] })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ id: "data-type-item-n".concat(index, "__delete"), "data-testid": "data-type-item-n".concat(index, "__delete"), ouiaId: "delete-field", className: "editable-item__delete", variant: "plain", onClick: function (e) { return handleDelete(e, "mouse"); }, onKeyDown: function (event) {
                                    if (event.key === "Enter") {
                                        handleDelete(event, "keyboard");
                                    }
                                } }, { children: (0, jsx_runtime_1.jsx)(trash_icon_1.TrashIcon, {}) })) })] })) })))] })));
};
exports.default = DataTypeItem;
//# sourceMappingURL=DataTypeItem.js.map