"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicsTableRow = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var atoms_1 = require("../atoms");
require("./CharacteristicsTableRow.scss");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var CharacteristicsTableRow = function (props) {
    var modelIndex = props.modelIndex, characteristicIndex = props.characteristicIndex, characteristic = props.characteristic, areReasonCodesUsed = props.areReasonCodesUsed, scorecardBaselineScore = props.scorecardBaselineScore, dataFields = props.dataFields, onEdit = props.onEdit, onDelete = props.onDelete;
    var handleEdit = function (event) {
        event.preventDefault();
        event.stopPropagation();
        onEdit();
    };
    return ((0, jsx_runtime_1.jsx)("article", __assign({ id: "characteristic-n".concat(characteristicIndex), "data-testid": "characteristic-n".concat(characteristicIndex), className: "editable-item__inner", onClick: handleEdit, onKeyDown: function (e) {
            if (e.key === "Enter") {
                handleEdit(e);
            }
        }, "data-ouia-component-type": "characteristic-item", tabIndex: 0 }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true, style: { height: "100%" } }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)("strong", { children: characteristic.characteristic.name }) }), (0, jsx_runtime_1.jsxs)(Split_1.SplitItem, __assign({ isFilled: true }, { children: [(0, jsx_runtime_1.jsx)(atoms_1.CharacteristicLabels, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, activeCharacteristic: characteristic.characteristic, areReasonCodesUsed: areReasonCodesUsed, scorecardBaselineScore: scorecardBaselineScore }), (0, jsx_runtime_1.jsx)(CharacteristicAttributesList, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic.characteristic, areReasonCodesUsed: areReasonCodesUsed, dataFields: dataFields })] })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(atoms_1.CharacteristicsTableAction, { index: characteristicIndex, onDelete: onDelete }) })] })) })));
};
exports.CharacteristicsTableRow = CharacteristicsTableRow;
var CharacteristicAttributesList = function (props) {
    var modelIndex = props.modelIndex, characteristicIndex = props.characteristicIndex, characteristic = props.characteristic, areReasonCodesUsed = props.areReasonCodesUsed, dataFields = props.dataFields;
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useCallback)(function (attributeIndex) {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forPredicate()
            .build());
    }, [modelIndex, characteristicIndex, characteristic]);
    return ((0, jsx_runtime_1.jsx)("ul", { children: characteristic.Attribute.map(function (item, index) { return ((0, jsx_runtime_1.jsxs)("li", { children: [(0, atoms_1.CharacteristicPredicateLabel)(item.predicate, dataFields, validations(index)), (0, jsx_runtime_1.jsx)(atoms_1.AttributeLabels, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic, activeAttributeIndex: index, activeAttribute: item, areReasonCodesUsed: areReasonCodesUsed, characteristicReasonCode: characteristic.reasonCode })] }, index)); }) }));
};
//# sourceMappingURL=CharacteristicsTableRow.js.map