"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicReducer = void 0;
var Actions_1 = require("./Actions");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var AttributesReducer_1 = require("./AttributesReducer");
var immer_1 = require("immer");
var paths_1 = require("../paths");
pmml_editor_marshaller_1.Characteristic[immer_1.immerable] = true;
var CharacteristicReducer = function (historyService) {
    var attributesReducer = (0, AttributesReducer_1.AttributesReducer)(historyService);
    var delegateToAttributes = function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.Scorecard_AddAttribute:
            case Actions_1.Actions.Scorecard_UpdateAttribute:
            case Actions_1.Actions.Scorecard_DeleteAttribute:
                var characteristicIndex = action.payload.characteristicIndex;
                var attributes = state[characteristicIndex].Attribute;
                attributesReducer(attributes, action);
        }
        return state;
    };
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.Scorecard_UpdateCharacteristic:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forCharacteristics().forCharacteristic().build(), function (draft) {
                    var characteristicIndex = action.payload.characteristicIndex;
                    if (characteristicIndex >= 0 && characteristicIndex < draft.length) {
                        draft[characteristicIndex] = __assign(__assign({}, draft[characteristicIndex]), { name: action.payload.name, reasonCode: action.payload.reasonCode, baselineScore: action.payload.baselineScore });
                    }
                    if (action.payload.reasonCode !== undefined) {
                        draft[characteristicIndex].Attribute.forEach(function (attribute) { return (attribute.reasonCode = undefined); });
                    }
                });
                return state;
        }
        return delegateToAttributes(state, action);
    };
};
exports.CharacteristicReducer = CharacteristicReducer;
//# sourceMappingURL=CharacteristicReducer.js.map