"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PMMLReducer = void 0;
var Actions_1 = require("./Actions");
var paths_1 = require("../paths");
var MiningSchema_1 = require("../validation/MiningSchema");
var PMMLModelHelper_1 = require("../PMMLModelHelper");
var PMMLReducer = function (historyService, validationRegistry) {
    return function (state, action) {
        var _a;
        switch (action.type) {
            case Actions_1.Actions.Refresh:
                return action.payload.pmml;
            case Actions_1.Actions.SetVersion:
                historyService.batch(state, null, function (draft) {
                    draft.version = action.payload.version;
                });
                break;
            case Actions_1.Actions.Undo:
                return historyService.undo(state);
            case Actions_1.Actions.Redo:
                return historyService.redo(state);
            case Actions_1.Actions.Validate:
                var dataFields_1 = state.DataDictionary.DataField;
                var models = (_a = state.models) !== null && _a !== void 0 ? _a : [];
                models.forEach(function (model, modelIndex) {
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(state, modelIndex);
                    if (miningSchema !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().build());
                        (0, MiningSchema_1.validateMiningFieldsDataFieldReference)(modelIndex, dataFields_1, miningSchema.MiningField, validationRegistry);
                    }
                });
        }
        return state;
    };
};
exports.PMMLReducer = PMMLReducer;
//# sourceMappingURL=PMMLReducer.js.map