"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateBaselineScore = void 0;
var ValidationRegistry_1 = require("./ValidationRegistry");
var ValidationLevel_1 = require("./ValidationLevel");
var paths_1 = require("../paths");
var validateBaselineScore = function (modelIndex, useReasonCodes, baselineScore, characteristics, validationRegistry) {
    if ((useReasonCodes === undefined || useReasonCodes) &&
        baselineScore === undefined &&
        (characteristics.length === 0 ||
            characteristics.filter(function (characteristic) { return characteristic.baselineScore === undefined; }).length > 0)) {
        validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forBaselineScore().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "Baseline score is required"));
    }
};
exports.validateBaselineScore = validateBaselineScore;
//# sourceMappingURL=ModelCoreProperties.js.map