"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toNotifications = void 0;
var ValidationLevel_1 = require("./ValidationLevel");
var toNotifications = function (normalizedPosixPathRelativeToTheWorkspaceRoot, validationEntries) {
    var mapValidationLevel = function (level) {
        switch (level) {
            case ValidationLevel_1.ValidationLevel.ERROR:
                return "ERROR";
            case ValidationLevel_1.ValidationLevel.WARNING:
                return "WARNING";
        }
    };
    return validationEntries.map(function (validationEntry) {
        var _a;
        return {
            normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
            message: (_a = validationEntry.message) !== null && _a !== void 0 ? _a : "",
            type: "PROBLEM",
            severity: mapValidationLevel(validationEntry.level),
        };
    });
};
exports.toNotifications = toNotifications;
//# sourceMappingURL=NotificationsFactory.js.map