var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from "react";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { filterDOMProps } from "uniforms";
filterDOMProps.register("decimal", "minCount", "autoValue", "isDisabled", "exclusiveMaximum", "exclusiveMinimum", "menuAppendTo");
export default function wrapField(_a, children) {
    var { id, label, type, disabled, error, errorMessage, showInlineError, help, required, description } = _a, props = __rest(_a, ["id", "label", "type", "disabled", "error", "errorMessage", "showInlineError", "help", "required", "description"]);
    return (React.createElement(FormGroup, Object.assign({ "data-testid": "wrapper-field", fieldId: id, label: label, labelIcon: description ? (React.createElement(Popover, { bodyContent: description },
            React.createElement("button", { type: "button", "aria-label": "field description", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help" },
                React.createElement(HelpIcon, { noVerticalAlign: true })))) : undefined, isRequired: required, validated: error ? "error" : "default", type: type, helperText: help, helperTextInvalid: errorMessage }, filterDOMProps(props)), children));
}
//# sourceMappingURL=wrapField.js.map