"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateSvg = void 0;
var __path = require("path");
var vscode = require("vscode");
var ConfigurationInterpolation_1 = require("./ConfigurationInterpolation");
var encoder = new TextEncoder();
function generateSvg(args) {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function () {
        var i18n, editor, previewSvg, fileType, svgFilenameTemplateId, svgFilePathTemplateId, svgFilenameTemplate, svgFilePathTemplate, svgFileName, svgFilePath, svgUri;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    i18n = args.vsCodeI18n.getCurrent();
                    editor = (_a = args.editorStore.activeEditor) !== null && _a !== void 0 ? _a : Array.from(args.editorStore.openEditors)
                        .filter(function (e) { var _a; return e.document.document.uri === ((_a = vscode.window.activeTextEditor) === null || _a === void 0 ? void 0 : _a.document.uri); })
                        .pop();
                    if (!editor) {
                        console.info("Unable to create SVG because there's no matching Editor that can generate SVGs.");
                        return [2];
                    }
                    return [4, editor.getPreview()];
                case 1:
                    previewSvg = _c.sent();
                    if (!previewSvg) {
                        console.info("Unable to create SVG for '".concat(editor.document.document.uri.fsPath, "'"));
                        return [2];
                    }
                    fileType = (_b = args.editorEnvelopeLocator.getEnvelopeMapping(__path.parse(editor.document.document.uri.path).base)) === null || _b === void 0 ? void 0 : _b.type;
                    svgFilenameTemplateId = "kogito.".concat(fileType, ".svgFilenameTemplate");
                    svgFilePathTemplateId = "kogito.".concat(fileType, ".svgFilePath");
                    svgFilenameTemplate = vscode.workspace.getConfiguration().get(svgFilenameTemplateId, "");
                    svgFilePathTemplate = vscode.workspace.getConfiguration().get(svgFilePathTemplateId, "");
                    if (__path.parse(svgFilenameTemplate).dir) {
                        vscode.window.showErrorMessage("The kogito.".concat(fileType, ".svgFilenameTemplate setting should be a valid filename, without a path prefix. Current value: ").concat(svgFilenameTemplate));
                        return [2];
                    }
                    svgFileName = (0, ConfigurationInterpolation_1.getInterpolatedConfigurationValue)({
                        currentFileAbsolutePosixPath: editor.document.document.uri.path,
                        value: (0, ConfigurationInterpolation_1.definitelyPosixPath)(svgFilenameTemplate) || "".concat(ConfigurationInterpolation_1.configurationTokenKeys["${fileBasenameNoExtension}"], "-svg.svg"),
                    });
                    svgFilePath = (0, ConfigurationInterpolation_1.getInterpolatedConfigurationValue)({
                        currentFileAbsolutePosixPath: editor.document.document.uri.path,
                        value: (0, ConfigurationInterpolation_1.definitelyPosixPath)(svgFilePathTemplate) || "".concat(ConfigurationInterpolation_1.configurationTokenKeys["${fileDirname}"]),
                    });
                    svgUri = editor.document.document.uri.with({ path: __path.posix.resolve(svgFilePath, svgFileName) });
                    return [4, vscode.workspace.fs.writeFile(svgUri, encoder.encode(previewSvg))];
                case 2:
                    _c.sent();
                    if (args.displayNotification) {
                        vscode.window.showInformationMessage(i18n.savedSvg(svgFileName), i18n.openSvg).then(function (selection) {
                            if (selection !== i18n.openSvg) {
                                return;
                            }
                            args.vscodeWorkspace.openFile(svgUri.fsPath);
                        });
                    }
                    return [2];
            }
        });
    });
}
exports.generateSvg = generateSvg;
//# sourceMappingURL=generateSvg.js.map