"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeResourceContentServiceForDanglingFiles = void 0;
var api_1 = require("@kie-tools-core/workspace/dist/api");
var minimatch_1 = require("minimatch");
var vscode = require("vscode");
var __path = require("path");
var paths_1 = require("../paths/paths");
var VsCodeResourceContentServiceForDanglingFiles = (function () {
    function VsCodeResourceContentServiceForDanglingFiles(args) {
        this.args = args;
        this.workspaceRootAbsoluteFsPath = __path.dirname(this.args.openFileAbsoluteFsPath);
    }
    VsCodeResourceContentServiceForDanglingFiles.prototype.list = function (pattern, opts) {
        return __awaiter(this, void 0, void 0, function () {
            var files, minimatch, regexp_1, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4, vscode.workspace.fs.readDirectory(vscode.Uri.file(this.workspaceRootAbsoluteFsPath))];
                    case 1:
                        files = _a.sent();
                        minimatch = new minimatch_1.Minimatch(pattern);
                        regexp_1 = minimatch.makeRe();
                        return [2, new api_1.ResourcesList(pattern, files.flatMap(function (_a) {
                                var _b = __read(_a, 2), p = _b[0], fileType = _b[1];
                                var matched = fileType === 1 &&
                                    (regexp_1.test("/" + p) || regexp_1.test(p));
                                return matched ? (0, paths_1.toPosixPath)(p) : [];
                            }))];
                    case 2:
                        e_1 = _a.sent();
                        return [2, new api_1.ResourcesList(pattern, [])];
                    case 3: return [2];
                }
            });
        });
    };
    VsCodeResourceContentServiceForDanglingFiles.prototype.get = function (normalizedPosixPathRelativeToTheWorkspaceRoot, opts) {
        return __awaiter(this, void 0, void 0, function () {
            var normalizedFsPathRelativeToTheWorkspaceRoot, absoluteFsPath, content, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (__path.isAbsolute(normalizedPosixPathRelativeToTheWorkspaceRoot)) {
                            throw new Error("VS CODE RESOURCE CONTENT API IMPL FOR DANGLING FILES: Can't work with absolute paths. All paths must be relative to folder of the open file.");
                        }
                        normalizedFsPathRelativeToTheWorkspaceRoot = (0, paths_1.toFsPath)(normalizedPosixPathRelativeToTheWorkspaceRoot);
                        absoluteFsPath = __path.join(this.workspaceRootAbsoluteFsPath, normalizedFsPathRelativeToTheWorkspaceRoot);
                        if (__path.resolve(this.workspaceRootAbsoluteFsPath, normalizedFsPathRelativeToTheWorkspaceRoot) !== absoluteFsPath) {
                            throw new Error("VS CODE RESOURCE CONTENT API IMPL FOR DANGLING FILES: Path relative to the root folder trying to access files outside of it.");
                        }
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4, vscode.workspace.fs.readFile(vscode.Uri.file(absoluteFsPath))];
                    case 2:
                        content = _a.sent();
                        if ((opts === null || opts === void 0 ? void 0 : opts.type) === api_1.ContentType.BINARY) {
                            return [2, new api_1.ResourceContent(normalizedPosixPathRelativeToTheWorkspaceRoot, Buffer.from(content).toString("base64"), api_1.ContentType.BINARY)];
                        }
                        else {
                            return [2, new api_1.ResourceContent(normalizedPosixPathRelativeToTheWorkspaceRoot, Buffer.from(content).toString(), api_1.ContentType.TEXT)];
                        }
                        return [3, 4];
                    case 3:
                        e_2 = _a.sent();
                        console.error("VS CODE RESOURCE CONTENT API IMPL FOR DANGLING FILES: Error reading file ".concat(normalizedPosixPathRelativeToTheWorkspaceRoot, ". Returning undefined."), e_2);
                        return [2, new api_1.ResourceContent(normalizedPosixPathRelativeToTheWorkspaceRoot, undefined, opts === null || opts === void 0 ? void 0 : opts.type)];
                    case 4: return [2];
                }
            });
        });
    };
    return VsCodeResourceContentServiceForDanglingFiles;
}());
exports.VsCodeResourceContentServiceForDanglingFiles = VsCodeResourceContentServiceForDanglingFiles;
//# sourceMappingURL=VsCodeResourceContentServiceForDanglingFiles.js.map