import React, { useState } from "react";
import { ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, Toolbar, ToolbarContent, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import _ from "lodash";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
var Category;
(function (Category) {
    Category["CUSTOM_DASHBOARD_NAME"] = "Custom Dashboard name";
})(Category || (Category = {}));
const CustomDashboardListToolbar = ({ applyFilter, filterDashboardNames, setFilterDashboardNames, ouiaSafe, ouiaId, }) => {
    const [dashboardNameInput, setDashboardNameInput] = useState("");
    const doResetFilter = () => {
        applyFilter({
            customDashboardNames: [],
        });
        setFilterDashboardNames([]);
    };
    const doRefresh = () => {
        applyFilter({
            customDashboardNames: [...filterDashboardNames],
        });
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            dashboardNameInput.length > 0 && doApplyFilter();
        }
    };
    const onDeleteFilterGroup = (categoryName, value) => {
        const newFilterDashboardNames = [...filterDashboardNames];
        if (categoryName === Category.CUSTOM_DASHBOARD_NAME) {
            _.remove(newFilterDashboardNames, (status) => {
                return status === value;
            });
            setFilterDashboardNames(newFilterDashboardNames);
            applyFilter({
                customDashboardNames: newFilterDashboardNames,
            });
        }
    };
    const doApplyFilter = () => {
        const newDashboardNames = [...filterDashboardNames];
        if (dashboardNameInput && !newDashboardNames.includes(dashboardNameInput)) {
            newDashboardNames.push(dashboardNameInput);
            setFilterDashboardNames(newDashboardNames);
        }
        setDashboardNameInput("");
        applyFilter({
            customDashboardNames: newDashboardNames,
        });
    };
    const toggleGroupItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarGroup, { variant: "filter-group" },
            React.createElement(ToolbarFilter, { key: "input-customDashboard-name", chips: filterDashboardNames, deleteChip: onDeleteFilterGroup, categoryName: Category.CUSTOM_DASHBOARD_NAME },
                React.createElement(InputGroup, null,
                    React.createElement(TextInput, { name: "customDashboardName", id: "customDashboardName", type: "search", "aria-label": "Dashboard name", onChange: setDashboardNameInput, onKeyPress: onEnterClicked, placeholder: "Filter by dashboard name", value: dashboardNameInput, "data-testid": "search-input" }))),
            React.createElement(ToolbarItem, null,
                React.createElement(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter, "data-testid": "apply-filter" }, "Apply Filter")))));
    const toolbarItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarToggleGroup, { toggleIcon: React.createElement(FilterIcon, null), breakpoint: "xl" }, toggleGroupItems),
        React.createElement(ToolbarGroup, { variant: "icon-button-group" },
            React.createElement(ToolbarItem, null,
                React.createElement(Tooltip, { content: "Refresh" },
                    React.createElement(Button, { variant: "plain", onClick: doRefresh, id: "refresh", "data-testid": "refresh" },
                        React.createElement(SyncIcon, null)))))));
    return (React.createElement(Toolbar, Object.assign({ id: "custom-dashboard-list-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default" }, componentOuiaProps(ouiaId, "custom-dashboard-list-toolbar", ouiaSafe)),
        React.createElement(ToolbarContent, null, toolbarItems)));
};
export default CustomDashboardListToolbar;
//# sourceMappingURL=CustomDashboardListToolbar.js.map